/*
 * Decompiled with CFR 0.152.
 */
package ch.serverrocket.minerva.bansystem;

import ch.serverrocket.command.CommandUsage;
import ch.serverrocket.config.Configs;
import ch.serverrocket.database.duty.DutyDataService;
import ch.serverrocket.database.player.PlayerData;
import ch.serverrocket.database.player.PlayerDataService;
import ch.serverrocket.database.reports.ModerationDataService;
import ch.serverrocket.database.reports.ModerationHistoryData;
import ch.serverrocket.lang.Langs;
import ch.serverrocket.messages.PrefixManager;
import com.hypixel.hytale.server.core.Message;
import com.hypixel.hytale.server.core.command.system.CommandContext;
import com.hypixel.hytale.server.core.command.system.CommandSender;
import com.hypixel.hytale.server.core.command.system.arguments.system.Argument;
import com.hypixel.hytale.server.core.command.system.arguments.system.OptionalArg;
import com.hypixel.hytale.server.core.command.system.arguments.types.ArgTypes;
import com.hypixel.hytale.server.core.command.system.arguments.types.ArgumentType;
import com.hypixel.hytale.server.core.command.system.basecommands.CommandBase;
import com.hypixel.hytale.server.core.universe.PlayerRef;
import java.util.UUID;
import javax.annotation.Nonnull;

public class UnbanCommand
extends CommandBase {
    private final OptionalArg<String> targetArg = this.withOptionalArg("player", "serverrocket.minerva.moderation.target", (ArgumentType)ArgTypes.STRING);

    public UnbanCommand() {
        super("unban", "serverrocket.minerva.unban.desc");
    }

    protected void executeSync(@Nonnull CommandContext context) {
        if (!context.sender().hasPermission("serverrocket.minerva.ban")) {
            String var13 = PrefixManager.serverrocket();
            context.sendMessage(Message.raw((String)(var13 + " " + Langs.serverrocket().noPermission())));
        } else {
            new UUID(0L, 0L);
            try {
                CommandSender var4 = context.sender();
                if (var4 instanceof PlayerRef) {
                    PlayerRef pr = (PlayerRef)var4;
                    UUID senderUuid = pr.getUuid();
                    if (Configs.minerva().playerHasToBeOnDuty() && !DutyDataService.isOnDuty(senderUuid)) {
                        String var12 = PrefixManager.minerva();
                        context.sendMessage(Message.raw((String)(var12 + Langs.minerva().playerHasToBeOnDuty())));
                        return;
                    }
                }
            }
            catch (Throwable var4) {
                // empty catch block
            }
            if (CommandUsage.requireArgs(context, new Argument[]{this.targetArg})) {
                String targetName = (String)this.targetArg.get(context);
                PlayerData targetData = PlayerDataService.getByName(targetName);
                if (targetData == null) {
                    String var11 = PrefixManager.minerva();
                    context.sendMessage(Message.raw((String)(var11 + Langs.minerva().playerNotFound())));
                } else {
                    UUID targetUuid = targetData.getUuid();
                    ModerationHistoryData activeBan = ModerationDataService.getActiveModeration(targetUuid, "BAN");
                    if (activeBan == null) {
                        String var10 = PrefixManager.minerva();
                        context.sendMessage(Message.raw((String)(var10 + String.format(Langs.minerva().moderationNotBanned(), targetData.getDisplayName()))));
                    } else {
                        ModerationDataService.deactivateModeration(targetUuid, "BAN");
                        String var10001 = PrefixManager.minerva();
                        context.sendMessage(Message.raw((String)(var10001 + String.format(Langs.minerva().moderationUnbanned(), targetData.getDisplayName()))));
                    }
                }
            }
        }
    }
}

