/*
 * Decompiled with CFR 0.152.
 */
package ch.serverrocket.minerva.bansystem;

import ch.serverrocket.command.CommandUsage;
import ch.serverrocket.config.Configs;
import ch.serverrocket.database.duty.DutyDataService;
import ch.serverrocket.database.reports.ModerationDataService;
import ch.serverrocket.database.reports.ModerationReasonData;
import ch.serverrocket.lang.Langs;
import ch.serverrocket.messages.PrefixManager;
import com.hypixel.hytale.component.Ref;
import com.hypixel.hytale.component.Store;
import com.hypixel.hytale.server.core.Message;
import com.hypixel.hytale.server.core.command.system.CommandContext;
import com.hypixel.hytale.server.core.command.system.arguments.system.Argument;
import com.hypixel.hytale.server.core.command.system.arguments.system.OptionalArg;
import com.hypixel.hytale.server.core.command.system.arguments.types.ArgTypes;
import com.hypixel.hytale.server.core.command.system.arguments.types.ArgumentType;
import com.hypixel.hytale.server.core.command.system.basecommands.AbstractPlayerCommand;
import com.hypixel.hytale.server.core.universe.PlayerRef;
import com.hypixel.hytale.server.core.universe.world.World;
import com.hypixel.hytale.server.core.universe.world.storage.EntityStore;
import java.util.List;
import org.checkerframework.checker.nullness.compatqual.NonNullDecl;

public class WarnCommand
extends AbstractPlayerCommand {
    private final OptionalArg<PlayerRef> targetArg = this.withOptionalArg("player", "serverrocket.minerva.moderation.target", (ArgumentType)ArgTypes.PLAYER_REF);
    private final OptionalArg<String> reasonArg = this.withOptionalArg("reason", "serverrocket.minerva.moderation.reason", (ArgumentType)ArgTypes.STRING);

    public WarnCommand() {
        super("warn", "serverrocket.minerva.warn.desc");
    }

    protected void execute(@NonNullDecl CommandContext context, @NonNullDecl Store<EntityStore> store, @NonNullDecl Ref<EntityStore> ref, @NonNullDecl PlayerRef playerRef, @NonNullDecl World world) {
        if (!context.sender().hasPermission("serverrocket.minerva.warn")) {
            String var16 = PrefixManager.serverrocket();
            context.sendMessage(Message.raw((String)(var16 + " " + Langs.serverrocket().noPermission())));
        } else if (Configs.minerva().playerHasToBeOnDuty() && !DutyDataService.isOnDuty(context.sender().getUuid())) {
            String var15 = PrefixManager.minerva();
            context.sendMessage(Message.raw((String)(var15 + Langs.minerva().playerHasToBeOnDuty())));
        } else if (CommandUsage.requireArgs(context, new Argument[]{this.targetArg, this.reasonArg})) {
            PlayerRef target = (PlayerRef)this.targetArg.get(context);
            String reasonInput = (String)this.reasonArg.get(context);
            boolean numeric = false;
            ModerationReasonData reason = null;
            try {
                int index = Integer.parseInt(reasonInput);
                numeric = true;
                reason = ModerationDataService.getReasonByIndex("WARN", index);
            }
            catch (NumberFormatException var11) {
                reason = ModerationDataService.getReasonByName(reasonInput);
            }
            if (reason != null && "WARN".equalsIgnoreCase(reason.getType())) {
                ModerationDataService.recordModeration(target.getUuid(), context.sender().getUuid(), "WARN", reason.getId(), null, null);
                String var13 = PrefixManager.minerva();
                target.sendMessage(Message.raw((String)(var13 + " You have received a warning: " + reason.getName())));
                var13 = PrefixManager.minerva();
                context.sendMessage(Message.raw((String)(var13 + String.format(Langs.minerva().moderationActionSuccess(), "WARN", target.getUsername()))));
            } else {
                String var10001 = PrefixManager.minerva();
                context.sendMessage(Message.raw((String)(var10001 + String.format(Langs.minerva().moderationIdNotFound(), reasonInput, "WARN"))));
                if (numeric) {
                    this.sendReasonList(context, "WARN");
                }
            }
        }
    }

    private void sendReasonList(CommandContext context, String type) {
        List<ModerationReasonData> reasons = ModerationDataService.getReasonsByType(type);
        if (reasons.isEmpty()) {
            String var8 = PrefixManager.minerva();
            context.sendMessage(Message.raw((String)(var8 + "Es wurden noch keine Gr\u00fcnde f\u00fcr " + type + " konfiguriert.")));
        } else {
            String var10001 = PrefixManager.minerva();
            context.sendMessage(Message.raw((String)(var10001 + "Verf\u00fcgbare Gr\u00fcnde f\u00fcr " + type + ":")));
            for (int i = 0; i < reasons.size(); ++i) {
                ModerationReasonData r = reasons.get(i);
                String durationStr = r.getDefaultDuration() != null && r.getDefaultDuration() != 0 ? this.formatDuration(r.getDefaultDuration()) : "Permanent";
                context.sendMessage(Message.raw((String)("  " + (i + 1) + ". " + r.getName() + " [" + durationStr + "]")));
            }
            var10001 = PrefixManager.minerva();
            context.sendMessage(Message.raw((String)(var10001 + Langs.minerva().moderationWarnUsage())));
        }
    }

    private String formatDuration(int seconds) {
        if (seconds <= 0) {
            return "Permanent";
        }
        if (seconds % 31536000 == 0) {
            return seconds / 31536000 + " Years";
        }
        if (seconds % 2592000 == 0) {
            return seconds / 2592000 + " Months";
        }
        if (seconds % 604800 == 0) {
            return seconds / 604800 + " Weeks";
        }
        if (seconds % 86400 == 0) {
            return seconds / 86400 + " Days";
        }
        return seconds % 3600 == 0 ? seconds / 3600 + " Hours" : seconds / 60 + " Minutes";
    }
}

