/*
 * Decompiled with CFR 0.152.
 */
package ch.serverrocket.minerva.bansystem.reason;

import ch.serverrocket.command.CommandUsage;
import ch.serverrocket.config.Configs;
import ch.serverrocket.database.duty.DutyDataService;
import ch.serverrocket.database.reports.ModerationDataService;
import ch.serverrocket.lang.Langs;
import ch.serverrocket.messages.PrefixManager;
import com.hypixel.hytale.server.core.Message;
import com.hypixel.hytale.server.core.command.system.CommandContext;
import com.hypixel.hytale.server.core.command.system.arguments.system.Argument;
import com.hypixel.hytale.server.core.command.system.arguments.system.OptionalArg;
import com.hypixel.hytale.server.core.command.system.arguments.types.ArgTypes;
import com.hypixel.hytale.server.core.command.system.arguments.types.ArgumentType;
import com.hypixel.hytale.server.core.command.system.basecommands.CommandBase;
import javax.annotation.Nonnull;

public class ModReasonAddCommand
extends CommandBase {
    private final OptionalArg<String> typeArg = this.withOptionalArg("type", "serverrocket.minerva.modreason.type", (ArgumentType)ArgTypes.STRING);
    private final OptionalArg<String> nameArg = this.withOptionalArg("name", "serverrocket.minerva.modreason.name", (ArgumentType)ArgTypes.STRING);
    private final OptionalArg<String> durationArg = this.withOptionalArg("duration", "serverrocket.minerva.modreason.duration", (ArgumentType)ArgTypes.STRING);

    public ModReasonAddCommand() {
        super("add", "serverrocket.minerva.modreason.add.desc");
    }

    protected void executeSync(@Nonnull CommandContext context) {
        if (!context.sender().hasPermission("serverrocket.minerva.moderation.manage")) {
            String var8 = PrefixManager.serverrocket();
            context.sendMessage(Message.raw((String)(var8 + " " + Langs.serverrocket().noPermission())));
        } else if (Configs.minerva().playerHasToBeOnDuty() && !DutyDataService.isOnDuty(context.sender().getUuid())) {
            String var7 = PrefixManager.minerva();
            context.sendMessage(Message.raw((String)(var7 + Langs.minerva().playerHasToBeOnDuty())));
        } else if (CommandUsage.requireArgs(context, new Argument[]{this.typeArg, this.nameArg, this.durationArg})) {
            String type = (String)this.typeArg.get(context);
            String name = (String)this.nameArg.get(context);
            String durationStr = (String)this.durationArg.get(context);
            Integer durationInSeconds = this.parseDuration(durationStr);
            if (durationInSeconds == null) {
                context.sendMessage(Message.raw((String)(PrefixManager.minerva() + "Ung\u00fcltiges Zeitformat. Beispiel: 10m, 1d, 1w, 1mo, 1y. Nutze 0 f\u00fcr permanent.")));
            } else if (ModerationDataService.exists(name)) {
                String var6 = PrefixManager.minerva();
                context.sendMessage(Message.raw((String)(var6 + String.format(Langs.minerva().moderationReasonAlreadyExists(), name))));
            } else {
                ModerationDataService.addModerationReason(type, name, durationInSeconds);
                String var10001 = PrefixManager.minerva();
                context.sendMessage(Message.raw((String)(var10001 + String.format(Langs.minerva().moderationReasonAdded(), name, type.toUpperCase()))));
            }
        }
    }

    private Integer parseDuration(String input) {
        if (!input.equals("0") && !input.equalsIgnoreCase("permanent")) {
            try {
                int value = Integer.parseInt(input.replaceAll("[^0-9]", ""));
                return switch (input.replaceAll("[0-9]", "").toLowerCase()) {
                    case "m", "min", "minutes" -> value * 60;
                    case "h", "hour", "hours" -> value * 3600;
                    case "d", "day", "days" -> value * 86400;
                    case "w", "week", "weeks" -> value * 604800;
                    case "mo", "month", "months" -> value * 2592000;
                    case "y", "year", "years" -> value * 31536000;
                    case "" -> value;
                    default -> null;
                };
            }
            catch (Exception var6) {
                return null;
            }
        }
        return 0;
    }
}

