/*
 * Decompiled with CFR 0.152.
 */
package ch.serverrocket.minerva.reportsystem;

import ch.serverrocket.command.CommandUsage;
import ch.serverrocket.config.Configs;
import ch.serverrocket.database.duty.DutyDataService;
import ch.serverrocket.database.reports.ReportsDataService;
import ch.serverrocket.database.reports.ReportsReasonData;
import ch.serverrocket.database.reports.ReportsReasonDataService;
import ch.serverrocket.lang.Langs;
import ch.serverrocket.messages.PrefixManager;
import com.hypixel.hytale.component.Ref;
import com.hypixel.hytale.component.Store;
import com.hypixel.hytale.server.core.Message;
import com.hypixel.hytale.server.core.command.system.AbstractCommand;
import com.hypixel.hytale.server.core.command.system.CommandContext;
import com.hypixel.hytale.server.core.command.system.CommandSender;
import com.hypixel.hytale.server.core.command.system.arguments.system.RequiredArg;
import com.hypixel.hytale.server.core.command.system.arguments.types.ArgTypes;
import com.hypixel.hytale.server.core.command.system.arguments.types.ArgumentType;
import com.hypixel.hytale.server.core.command.system.basecommands.AbstractPlayerCommand;
import com.hypixel.hytale.server.core.entity.entities.Player;
import com.hypixel.hytale.server.core.universe.PlayerRef;
import com.hypixel.hytale.server.core.universe.world.World;
import com.hypixel.hytale.server.core.universe.world.storage.EntityStore;
import java.util.List;
import org.checkerframework.checker.nullness.compatqual.NonNullDecl;

public class ReportCommand
extends AbstractPlayerCommand {
    private final RequiredArg<PlayerRef> playerArg = this.withRequiredArg("player", "serverrocket.minerva.report.target", (ArgumentType)ArgTypes.PLAYER_REF);
    private final RequiredArg<String> reasonArg = this.withRequiredArg("reason", "serverrocket.minerva.report.reason", (ArgumentType)ArgTypes.STRING);

    public ReportCommand() {
        super("report", "serverrocket.minerva.report.desc");
        CommandUsage.addUsageVariant((AbstractCommand)this);
    }

    protected void execute(@NonNullDecl CommandContext context, @NonNullDecl Store<EntityStore> store, @NonNullDecl Ref<EntityStore> ref, @NonNullDecl PlayerRef playerRef, @NonNullDecl World world) {
        if (!context.sender().hasPermission("serverrocket.minerva.report")) {
            String var15 = PrefixManager.serverrocket();
            context.sendMessage(Message.raw((String)(var15 + " " + Langs.serverrocket().noPermission())));
            return;
        }
        if (Configs.minerva().playerHasToBeOnDuty() && !DutyDataService.isOnDuty(playerRef.getUuid())) {
            String var14 = PrefixManager.minerva();
            context.sendMessage(Message.raw((String)(var14 + Langs.minerva().playerHasToBeOnDuty())));
            return;
        }
        PlayerRef target = (PlayerRef)this.playerArg.get(context);
        String reasonInput = (String)this.reasonArg.get(context);
        boolean numeric = false;
        ReportsReasonData reason = null;
        try {
            int index = Integer.parseInt(reasonInput);
            numeric = true;
            List<ReportsReasonData> activeReasons = ReportsReasonDataService.getActiveReasons();
            if (index > 0 && index <= activeReasons.size()) {
                reason = activeReasons.get(index - 1);
            }
        }
        catch (NumberFormatException var12) {
            reason = ReportsReasonDataService.getByName(reasonInput);
        }
        if (reason != null && reason.getStatus() != 0) {
            ReportsDataService.createReport(playerRef.getUuid(), target.getUuid(), reason.getId(), null);
            String var13 = PrefixManager.minerva();
            context.sendMessage(Message.raw((String)(var13 + Langs.minerva().reportSuccess())));
            this.notifyStaff(world, playerRef.getUsername(), target.getUsername(), reason.getName());
        } else {
            String var10001 = PrefixManager.minerva();
            context.sendMessage(Message.raw((String)(var10001 + String.format(Langs.minerva().reportsreasonNotFound(), reasonInput))));
            this.sendReasonList(context);
        }
    }

    private void sendReasonList(CommandContext context) {
        List<ReportsReasonData> reasons = ReportsReasonDataService.getActiveReasons();
        if (reasons.isEmpty()) {
            context.sendMessage(Message.raw((String)(PrefixManager.minerva() + "No report reasons have been configured yet.")));
        } else {
            context.sendMessage(Message.raw((String)(PrefixManager.minerva() + "Available reasons:")));
            for (int i = 0; i < reasons.size(); ++i) {
                ReportsReasonData r = reasons.get(i);
                context.sendMessage(Message.raw((String)("  " + (i + 1) + ". " + r.getName())));
            }
        }
    }

    public Message getUsageString(CommandSender sender) {
        return super.getUsageString(sender);
    }

    private void notifyStaff(World world, String reporterName, String reportedName, String reason) {
        String var10000 = PrefixManager.minerva();
        String base = var10000 + String.format(Langs.minerva().reportStaffNotification(), reporterName, reportedName, reason);
        boolean isMulti = "multi".equalsIgnoreCase(Configs.serverrocket().getNetwork().getMode());
        String serverTag = isMulti ? " [server: " + Configs.serverrocket().getNetwork().getCurrentServer() + "]" : "";
        String notification = base + serverTag;
        for (PlayerRef staff : world.getPlayerRefs()) {
            Player staffPlayer = (Player)staff.getReference().getStore().getComponent(staff.getReference(), Player.getComponentType());
            if (staffPlayer == null || !staffPlayer.hasPermission("serverrocket.minerva.report.receive")) continue;
            staff.sendMessage(Message.raw((String)notification));
        }
    }
}

