/*
 * Decompiled with CFR 0.152.
 */
package ch.serverrocket.minerva.reportsystem;

import ch.serverrocket.command.CommandUsage;
import ch.serverrocket.config.Configs;
import ch.serverrocket.config.configfiles.ServerRocketConfig;
import ch.serverrocket.database.reports.ReportsData;
import ch.serverrocket.database.reports.ReportsDataService;
import ch.serverrocket.messages.PrefixManager;
import com.hypixel.hytale.component.Ref;
import com.hypixel.hytale.component.Store;
import com.hypixel.hytale.server.core.Message;
import com.hypixel.hytale.server.core.command.system.CommandContext;
import com.hypixel.hytale.server.core.command.system.arguments.system.Argument;
import com.hypixel.hytale.server.core.command.system.arguments.system.OptionalArg;
import com.hypixel.hytale.server.core.command.system.arguments.types.ArgTypes;
import com.hypixel.hytale.server.core.command.system.arguments.types.ArgumentType;
import com.hypixel.hytale.server.core.command.system.basecommands.AbstractPlayerCommand;
import com.hypixel.hytale.server.core.universe.PlayerRef;
import com.hypixel.hytale.server.core.universe.world.World;
import com.hypixel.hytale.server.core.universe.world.storage.EntityStore;
import java.util.List;
import org.checkerframework.checker.nullness.compatqual.NonNullDecl;

public class ReportGotoCommand
extends AbstractPlayerCommand {
    private final OptionalArg<Integer> idArg = this.withOptionalArg("id", "serverrocket.minerva.report.goto.id", (ArgumentType)ArgTypes.INTEGER);

    public ReportGotoCommand() {
        super("reportgoto", "serverrocket.minerva.report.goto.desc");
    }

    protected void execute(@NonNullDecl CommandContext context, @NonNullDecl Store<EntityStore> store, @NonNullDecl Ref<EntityStore> ref, @NonNullDecl PlayerRef playerRef, @NonNullDecl World world) {
        if (!context.sender().hasPermission("serverrocket.minerva.dashboard.reports")) {
            context.sendMessage(Message.raw((String)(PrefixManager.serverrocket() + " You don't have permission.")));
        } else if (CommandUsage.requireArgs(context, new Argument[]{this.idArg})) {
            Integer id = null;
            try {
                id = (Integer)this.idArg.get(context);
            }
            catch (Exception exception) {
                // empty catch block
            }
            ReportsData data = ReportsDataService.getById(id);
            if (data == null) {
                String var19 = PrefixManager.minerva();
                context.sendMessage(Message.raw((String)(var19 + " Report not found: " + id)));
            } else {
                ServerRocketConfig.NetworkConfig net = Configs.serverrocket().getNetwork();
                boolean multi = "multi".equalsIgnoreCase(net.getMode());
                if (!multi) {
                    context.sendMessage(Message.raw((String)(PrefixManager.minerva() + " Network mode is SINGLE. No server transfer needed.")));
                } else {
                    String targetName = data.getSourceServer();
                    if (targetName != null && !targetName.isEmpty()) {
                        String current = net.getCurrentServer();
                        if (targetName.equalsIgnoreCase(current)) {
                            String var18 = PrefixManager.minerva();
                            context.sendMessage(Message.raw((String)(var18 + " You are already on the report's server (" + targetName + ").")));
                        } else {
                            ServerRocketConfig.ServerInfo target = this.findServer(net.getServers(), targetName);
                            if (target == null) {
                                String var17 = PrefixManager.minerva();
                                context.sendMessage(Message.raw((String)(var17 + " Unknown server in config: " + targetName)));
                            } else {
                                try {
                                    playerRef.referToServer(target.getHost(), target.getPort());
                                    String var16 = PrefixManager.minerva();
                                    context.sendMessage(Message.raw((String)(var16 + " Transferring to server " + targetName + "...")));
                                }
                                catch (Throwable t2) {
                                    String var10001 = PrefixManager.minerva();
                                    context.sendMessage(Message.raw((String)(var10001 + " Transfer failed: " + t2.getMessage())));
                                }
                            }
                        }
                    } else {
                        context.sendMessage(Message.raw((String)(PrefixManager.minerva() + " Report does not specify a source server.")));
                    }
                }
            }
        }
    }

    private ServerRocketConfig.ServerInfo findServer(List<ServerRocketConfig.ServerInfo> list, String name) {
        if (list == null) {
            return null;
        }
        for (ServerRocketConfig.ServerInfo s2 : list) {
            if (s2 == null || s2.getName() == null || !s2.getName().equalsIgnoreCase(name)) continue;
            return s2;
        }
        return null;
    }
}

