/*
 * Decompiled with CFR 0.152.
 */
package ch.serverrocket.minerva.staffdashboard;

import ch.serverrocket.config.Configs;
import ch.serverrocket.config.configfiles.ServerRocketConfig;
import ch.serverrocket.database.duty.DutyDataService;
import ch.serverrocket.database.economy.EconomyDataService;
import ch.serverrocket.database.economy.TransactionData;
import ch.serverrocket.database.player.PlayerData;
import ch.serverrocket.database.player.PlayerDataService;
import ch.serverrocket.database.reports.ModerationDataService;
import ch.serverrocket.database.reports.ModerationHistoryData;
import ch.serverrocket.database.reports.ModerationReasonData;
import ch.serverrocket.database.reports.ReportsData;
import ch.serverrocket.database.reports.ReportsDataService;
import ch.serverrocket.database.reports.ReportsReasonData;
import ch.serverrocket.database.reports.ReportsReasonDataService;
import ch.serverrocket.database.stockmarket.StockDataService;
import ch.serverrocket.lang.Langs;
import ch.serverrocket.messages.PrefixManager;
import ch.serverrocket.minerva.staffdashboard.StaffDashboardPageEventData;
import com.hypixel.hytale.component.Ref;
import com.hypixel.hytale.component.Store;
import com.hypixel.hytale.protocol.packets.interface_.CustomPageLifetime;
import com.hypixel.hytale.protocol.packets.interface_.CustomUIEventBindingType;
import com.hypixel.hytale.server.core.Message;
import com.hypixel.hytale.server.core.entity.entities.Player;
import com.hypixel.hytale.server.core.entity.entities.player.pages.InteractiveCustomUIPage;
import com.hypixel.hytale.server.core.ui.builder.EventData;
import com.hypixel.hytale.server.core.ui.builder.UICommandBuilder;
import com.hypixel.hytale.server.core.ui.builder.UIEventBuilder;
import com.hypixel.hytale.server.core.universe.PlayerRef;
import com.hypixel.hytale.server.core.universe.world.storage.EntityStore;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.UUID;

public class StaffDashboardPage
extends InteractiveCustomUIPage<StaffDashboardPageEventData> {
    public static final String LAYOUT = "Minerva/Dashboard.ui";
    private final PlayerRef playerRef;
    private String selectedReasonType = "REPORT";

    public StaffDashboardPage(PlayerRef playerRef) {
        super(playerRef, CustomPageLifetime.CanDismiss, StaffDashboardPageEventData.CODEC);
        this.playerRef = playerRef;
    }

    public void build(Ref<EntityStore> ref, UICommandBuilder builder, UIEventBuilder eventBuilder, Store<EntityStore> store) {
        builder.append(LAYOUT);
        builder.set("#DashboardTitle.Text", "Staff Dashboard");
        this.buildReports(builder, eventBuilder);
        eventBuilder.addEventBinding(CustomUIEventBindingType.Activating, "#DashboardFooterCloseButton", new EventData().append("Action", "close"), false);
        eventBuilder.addEventBinding(CustomUIEventBindingType.Activating, "#ReportsTab", new EventData().append("Action", "switch_tab").append("Tab", "reports"), false);
        eventBuilder.addEventBinding(CustomUIEventBindingType.Activating, "#DutyTab", new EventData().append("Action", "switch_tab").append("Tab", "duty"), false);
        eventBuilder.addEventBinding(CustomUIEventBindingType.Activating, "#PlayersTab", new EventData().append("Action", "switch_tab").append("Tab", "players"), false);
        eventBuilder.addEventBinding(CustomUIEventBindingType.Activating, "#ReasonsTab", new EventData().append("Action", "switch_tab").append("Tab", "reasons"), false);
        eventBuilder.addEventBinding(CustomUIEventBindingType.Activating, "#HistoryTab", new EventData().append("Action", "switch_tab").append("Tab", "history"), false);
        eventBuilder.addEventBinding(CustomUIEventBindingType.Activating, "#SettingsTab", new EventData().append("Action", "switch_tab").append("Tab", "settings"), false);
        eventBuilder.addEventBinding(CustomUIEventBindingType.Activating, "#DetailsBackButton", new EventData().append("Action", "switch_tab").append("Tab", "reports"), false);
    }

    private void buildReasons(UICommandBuilder builder, UIEventBuilder eventBuilder) {
        this.buildReasons(builder, eventBuilder, 0);
    }

    private void buildReasons(UICommandBuilder builder, UIEventBuilder eventBuilder, int page) {
        this.hideAllContainers(builder);
        builder.set("#DashboardReasonsControls.Visible", true);
        builder.set("#DashboardReasonsListArea.Visible", true);
        builder.clear("#DashboardReasonsList");
        eventBuilder.addEventBinding(CustomUIEventBindingType.Activating, "#TypeReport", new EventData().append("Action", "select_reason_type").append("ReasonType", "REPORT"), false);
        eventBuilder.addEventBinding(CustomUIEventBindingType.Activating, "#TypeBan", new EventData().append("Action", "select_reason_type").append("ReasonType", "BAN"), false);
        eventBuilder.addEventBinding(CustomUIEventBindingType.Activating, "#TypeMute", new EventData().append("Action", "select_reason_type").append("ReasonType", "MUTE"), false);
        eventBuilder.addEventBinding(CustomUIEventBindingType.Activating, "#TypeWarn", new EventData().append("Action", "select_reason_type").append("ReasonType", "WARN"), false);
        eventBuilder.addEventBinding(CustomUIEventBindingType.Activating, "#AddReasonButton", new EventData().append("Action", "add_reason").append("@ReasonName", "#ReasonNameInput.Value").append("@ReasonPriority", "#ReasonPriorityInput.Value").append("@ReasonDuration", "#ReasonDurationInput.Value").append("ReasonType", this.selectedReasonType), false);
        List<ReportsReasonData> reportReasons = null;
        List<ModerationReasonData> modReasons = null;
        int total = 0;
        if ("REPORT".equals(this.selectedReasonType)) {
            try {
                reportReasons = ReportsReasonDataService.getAllReasons();
                total = reportReasons != null ? reportReasons.size() : 0;
            }
            catch (Exception exception) {}
        } else {
            try {
                List<ModerationReasonData> allMods = ModerationDataService.getAllReasons();
                modReasons = allMods.stream().filter(r -> r.getType().equalsIgnoreCase(this.selectedReasonType)).toList();
                total = modReasons != null ? modReasons.size() : 0;
            }
            catch (Exception allMods) {
                // empty catch block
            }
        }
        int pageSize = 5;
        int totalPages = Math.max(1, (int)Math.ceil((double)total / (double)pageSize));
        if (page < 0) {
            page = 0;
        }
        if (page >= totalPages) {
            page = totalPages - 1;
        }
        builder.set("#ReasonsPageLabel.Text", "Page " + (page + 1) + "/" + totalPages);
        int start = page * pageSize;
        int end = Math.min(start + pageSize, total);
        if ("REPORT".equals(this.selectedReasonType)) {
            if (reportReasons != null) {
                for (int i = start; i < end; ++i) {
                    ReportsReasonData reason = reportReasons.get(i);
                    int idx = i - start;
                    String selector = "#DashboardReasonsList[" + idx + "]";
                    builder.append("#DashboardReasonsList", "Minerva/ReasonEntry.ui");
                    String var10001 = selector + " #ReasonName.Text";
                    String var10002 = reason.getName();
                    builder.set(var10001, "[REPORT] " + var10002 + " (P: " + reason.getPriority() + ")");
                    builder.set(selector + " #ToggleButton.Text", reason.getStatus() == 1 ? "Disable" : "Enable");
                    eventBuilder.addEventBinding(CustomUIEventBindingType.Activating, selector + " #ToggleButton", new EventData().append("Action", "toggle_reason").append("ReasonName", reason.getName()).append("ReasonType", "REPORT").append("Page", String.valueOf(page)), false);
                    eventBuilder.addEventBinding(CustomUIEventBindingType.Activating, selector + " #DeleteButton", new EventData().append("Action", "delete_reason").append("ReasonName", reason.getName()).append("ReasonType", "REPORT").append("Page", String.valueOf(page)), false);
                }
            }
        } else if (modReasons != null) {
            for (int i = start; i < end; ++i) {
                ModerationReasonData reason = modReasons.get(i);
                int idx = i - start;
                String selector = "#DashboardReasonsList[" + idx + "]";
                builder.append("#DashboardReasonsList", "Minerva/ReasonEntry.ui");
                String dur = reason.getDefaultDuration() != null ? " (" + this.formatDuration(reason.getDefaultDuration()) + ")" : "";
                String var23 = selector + " #ReasonName.Text";
                String var24 = reason.getType();
                builder.set(var23, "[" + var24 + "] " + reason.getName() + dur);
                builder.set(selector + " #ToggleButton.Text", reason.getStatus() == 1 ? "Disable" : "Enable");
                eventBuilder.addEventBinding(CustomUIEventBindingType.Activating, selector + " #ToggleButton", new EventData().append("Action", "toggle_reason").append("ReasonName", reason.getName()).append("ReasonType", reason.getType()).append("Page", String.valueOf(page)), false);
                eventBuilder.addEventBinding(CustomUIEventBindingType.Activating, selector + " #DeleteButton", new EventData().append("Action", "delete_reason").append("ReasonName", reason.getName()).append("ReasonType", reason.getType()).append("Page", String.valueOf(page)), false);
            }
        }
        builder.set("#ReasonsPrev.Visible", page > 0);
        if (page > 0) {
            eventBuilder.addEventBinding(CustomUIEventBindingType.Activating, "#ReasonsPrev", new EventData().append("Action", "reasons_prev").append("Page", String.valueOf(page - 1)), false);
        }
        builder.set("#ReasonsNext.Visible", page < totalPages - 1);
        if (page < totalPages - 1) {
            eventBuilder.addEventBinding(CustomUIEventBindingType.Activating, "#ReasonsNext", new EventData().append("Action", "reasons_next").append("Page", String.valueOf(page + 1)), false);
        }
    }

    private String formatDuration(int seconds) {
        if (seconds <= 0) {
            return "Permanent";
        }
        if (seconds % 31536000 == 0) {
            return seconds / 31536000 + "y";
        }
        if (seconds % 2592000 == 0) {
            return seconds / 2592000 + "mo";
        }
        if (seconds % 604800 == 0) {
            return seconds / 604800 + "w";
        }
        if (seconds % 86400 == 0) {
            return seconds / 86400 + "d";
        }
        return seconds % 3600 == 0 ? seconds / 3600 + "h" : seconds / 60 + "m";
    }

    private void buildReports(UICommandBuilder builder, UIEventBuilder eventBuilder) {
        this.buildReports(builder, eventBuilder, 0);
    }

    private void buildReports(UICommandBuilder builder, UIEventBuilder eventBuilder, int page) {
        List<ReportsData> reports;
        this.hideAllContainers(builder);
        builder.set("#DashboardReportListArea.Visible", true);
        builder.clear("#DashboardReportList");
        try {
            reports = ReportsDataService.getReports(true);
        }
        catch (Exception var17) {
            return;
        }
        int total = reports != null ? reports.size() : 0;
        int pageSize = 6;
        int totalPages = Math.max(1, (int)Math.ceil((double)total / (double)pageSize));
        if (page < 0) {
            page = 0;
        }
        if (page >= totalPages) {
            page = totalPages - 1;
        }
        builder.set("#ReportsPageLabel.Text", "Page " + (page + 1) + "/" + totalPages);
        if (reports != null && total > 0) {
            int start = page * pageSize;
            int end = Math.min(start + pageSize, total);
            for (int i = start; i < end; ++i) {
                ReportsData report = reports.get(i);
                int idx = i - start;
                String selector = "#DashboardReportList[" + idx + "]";
                builder.append("#DashboardReportList", "Minerva/ReportEntry.ui");
                PlayerData reported = PlayerDataService.getByUUID(report.getReportedUuid());
                String reportedName = reported != null ? reported.getDisplayName() : report.getReportedUuid().toString();
                String statusText = report.getStatus() == 1 ? " [In Progress]" : "";
                builder.set(selector + ".Text", "Report against: " + reportedName + " (" + report.getTimestamp() + ")" + statusText);
                eventBuilder.addEventBinding(CustomUIEventBindingType.Activating, selector, new EventData().append("Action", "view_report").append("ReportId", String.valueOf(report.getId())), false);
            }
        }
        builder.set("#ReportsPrev.Visible", page > 0);
        if (page > 0) {
            eventBuilder.addEventBinding(CustomUIEventBindingType.Activating, "#ReportsPrev", new EventData().append("Action", "reports_prev").append("Page", String.valueOf(page - 1)), false);
        }
        builder.set("#ReportsNext.Visible", page < totalPages - 1);
        if (page < totalPages - 1) {
            eventBuilder.addEventBinding(CustomUIEventBindingType.Activating, "#ReportsNext", new EventData().append("Action", "reports_next").append("Page", String.valueOf(page + 1)), false);
        }
    }

    private void buildPlayers(UICommandBuilder builder, UIEventBuilder eventBuilder, int page) {
        List<PlayerData> players;
        this.hideAllContainers(builder);
        builder.set("#DashboardPlayerList.Visible", true);
        builder.clear("#PlayerList");
        try {
            players = PlayerDataService.getAllPlayers();
        }
        catch (Exception var14) {
            return;
        }
        int total = players != null ? players.size() : 0;
        int pageSize = 5;
        int totalPages = Math.max(1, (int)Math.ceil((double)total / (double)pageSize));
        if (page < 0) {
            page = 0;
        }
        if (page >= totalPages) {
            page = totalPages - 1;
        }
        builder.set("#PlayersPageLabel.Text", "Page " + (page + 1) + "/" + totalPages);
        if (players != null && total > 0) {
            int start = page * pageSize;
            int end = Math.min(start + pageSize, total);
            for (int i = start; i < end; ++i) {
                PlayerData data = players.get(i);
                int idx = i - start;
                String selector = "#PlayerList[" + idx + "]";
                builder.append("#PlayerList", "Minerva/ReportEntry.ui");
                String var10001 = selector + ".Text";
                String var10002 = data.getDisplayName();
                builder.set(var10001, var10002 + " (" + String.valueOf(data.getUuid()) + ")");
                eventBuilder.addEventBinding(CustomUIEventBindingType.Activating, selector, new EventData().append("Action", "view_player").append("TargetUuid", data.getUuid().toString()), false);
            }
        }
        builder.set("#PlayersPrev.Visible", page > 0);
        if (page > 0) {
            eventBuilder.addEventBinding(CustomUIEventBindingType.Activating, "#PlayersPrev", new EventData().append("Action", "players_prev").append("Page", String.valueOf(page - 1)), false);
        }
        builder.set("#PlayersNext.Visible", page < totalPages - 1);
        if (page < totalPages - 1) {
            eventBuilder.addEventBinding(CustomUIEventBindingType.Activating, "#PlayersNext", new EventData().append("Action", "players_next").append("Page", String.valueOf(page + 1)), false);
        }
    }

    private void buildDuty(UICommandBuilder builder, UIEventBuilder eventBuilder, int page) {
        List<UUID> onDutyUuids;
        this.hideAllContainers(builder);
        builder.set("#DashboardDutyList.Visible", true);
        builder.clear("#DutyList");
        builder.set("#DashboardTitle.Text", "Staff Dashboard - On Duty");
        try {
            onDutyUuids = DutyDataService.getAllOnDuty();
        }
        catch (Exception var16) {
            return;
        }
        int total = onDutyUuids != null ? onDutyUuids.size() : 0;
        int pageSize = 5;
        int totalPages = Math.max(1, (int)Math.ceil((double)total / (double)pageSize));
        if (page < 0) {
            page = 0;
        }
        if (page >= totalPages) {
            page = totalPages - 1;
        }
        builder.set("#DutyPageLabel.Text", "Page " + (page + 1) + "/" + totalPages);
        if (onDutyUuids != null && total > 0) {
            int start = page * pageSize;
            int end = Math.min(start + pageSize, total);
            for (int i = start; i < end; ++i) {
                UUID uuid = onDutyUuids.get(i);
                int idx = i - start;
                String selector = "#DutyList[" + idx + "]";
                builder.append("#DutyList", "Minerva/ReportEntry.ui");
                PlayerData data = PlayerDataService.getByUUID(uuid);
                String displayName = data != null ? data.getDisplayName() : uuid.toString();
                builder.set(selector + ".Text", displayName + " (" + String.valueOf(uuid) + ")");
                eventBuilder.addEventBinding(CustomUIEventBindingType.Activating, selector, new EventData().append("Action", "view_player").append("TargetUuid", uuid.toString()), false);
            }
        }
        builder.set("#DutyPrev.Visible", page > 0);
        if (page > 0) {
            eventBuilder.addEventBinding(CustomUIEventBindingType.Activating, "#DutyPrev", new EventData().append("Action", "duty_prev").append("Page", String.valueOf(page - 1)), false);
        }
        builder.set("#DutyNext.Visible", page < totalPages - 1);
        if (page < totalPages - 1) {
            eventBuilder.addEventBinding(CustomUIEventBindingType.Activating, "#DutyNext", new EventData().append("Action", "duty_next").append("Page", String.valueOf(page + 1)), false);
        }
    }

    private void buildPlayerDetails(UICommandBuilder builder, UIEventBuilder eventBuilder, UUID uuid) {
        PlayerData data;
        this.hideAllContainers(builder);
        builder.set("#DashboardDetailsArea.Visible", true);
        builder.clear("#DetailsContent");
        try {
            data = PlayerDataService.getByUUID(uuid);
        }
        catch (Exception var11) {
            builder.set("#DetailsTitle.Text", Langs.minerva().dashboardErrorLoadingPlayer());
            return;
        }
        if (data == null) {
            builder.set("#DetailsTitle.Text", Langs.minerva().dashboardPlayerNotFound());
        } else {
            List<ModerationHistoryData> history;
            builder.set("#DetailsTitle.Text", "Player: " + data.getDisplayName());
            builder.append("#DetailsContent", "Minerva/ReasonEntry.ui");
            builder.set("#DetailsContent[0] #ReasonName.Text", "UUID: " + String.valueOf(data.getUuid()));
            builder.set("#DetailsContent[0] #ToggleButton.Visible", false);
            builder.set("#DetailsContent[0] #DeleteButton.Visible", false);
            builder.append("#DetailsContent", "Minerva/ReasonEntry.ui");
            builder.set("#DetailsContent[1] #ReasonName.Text", "First Joined: " + PlayerData.formatDate(data.getFirstJoin()));
            builder.set("#DetailsContent[1] #ToggleButton.Visible", false);
            builder.set("#DetailsContent[1] #DeleteButton.Visible", false);
            builder.append("#DetailsContent", "Minerva/ReasonEntry.ui");
            builder.set("#DetailsContent[2] #ReasonName.Text", "Last Seen: " + PlayerData.formatDate(data.getLastSeen()));
            builder.set("#DetailsContent[2] #ToggleButton.Visible", false);
            builder.set("#DetailsContent[2] #DeleteButton.Visible", false);
            builder.append("#DetailsContent", "Minerva/ReasonEntry.ui");
            builder.set("#DetailsContent[3] #ReasonName.Text", "Playtime: " + PlayerData.formatPlaytime(data.getPlaytime()));
            builder.set("#DetailsContent[3] #ToggleButton.Visible", false);
            builder.set("#DetailsContent[3] #DeleteButton.Visible", false);
            try {
                history = ModerationDataService.getModerationHistory(uuid);
            }
            catch (Exception var10) {
                return;
            }
            if (history != null) {
                boolean hasActiveBan = false;
                boolean hasActiveMute = false;
                for (ModerationHistoryData h2 : history) {
                    if (!h2.isActive() || h2.isExpired()) continue;
                    if ("BAN".equalsIgnoreCase(h2.getType())) {
                        hasActiveBan = true;
                    }
                    if (!"MUTE".equalsIgnoreCase(h2.getType())) continue;
                    hasActiveMute = true;
                }
                if (hasActiveBan) {
                    builder.set("#DetailsUnban.Visible", true);
                    eventBuilder.addEventBinding(CustomUIEventBindingType.Activating, "#DetailsUnban", new EventData().append("Action", "unban_player").append("TargetUuid", uuid.toString()), false);
                }
                if (hasActiveMute) {
                    builder.set("#DetailsUnmute.Visible", true);
                    eventBuilder.addEventBinding(CustomUIEventBindingType.Activating, "#DetailsUnmute", new EventData().append("Action", "unmute_player").append("TargetUuid", uuid.toString()), false);
                }
            }
            builder.set("#DetailsAction.Visible", true);
            builder.set("#DetailsAction.Text", "View History");
            eventBuilder.addEventBinding(CustomUIEventBindingType.Activating, "#DetailsAction", new EventData().append("Action", "view_history").append("TargetUuid", uuid.toString()).append("Page", "0"), false);
            builder.set("#DetailsTransactions.Visible", true);
            builder.set("#DetailsTransactions.Text", "View Transactions");
            eventBuilder.addEventBinding(CustomUIEventBindingType.Activating, "#DetailsTransactions", new EventData().append("Action", "view_transactions").append("TargetUuid", uuid.toString()), false);
            eventBuilder.addEventBinding(CustomUIEventBindingType.Activating, "#DetailsBackButton", new EventData().append("Action", "switch_tab").append("Tab", "players"), false);
        }
    }

    private void buildPlayerTransactionsPage(UICommandBuilder builder, UIEventBuilder eventBuilder, UUID targetUuid, int page) {
        this.hideAllContainers(builder);
        builder.set("#DashboardTransactionsArea.Visible", true);
        builder.clear("#TransactionsList");
        PlayerData data = PlayerDataService.getByUUID(targetUuid);
        String name = data != null ? data.getDisplayName() : targetUuid.toString();
        builder.set("#TransactionsTitle.Text", "Transactions: " + name);
        List<TransactionData> history = EconomyDataService.getHistory(targetUuid);
        int total = history != null ? history.size() : 0;
        int pageSize = 5;
        int totalPages = Math.max(1, (int)Math.ceil((double)total / (double)pageSize));
        if (page < 0) {
            page = 0;
        }
        if (page >= totalPages) {
            page = totalPages - 1;
        }
        builder.set("#TransactionsPageLabel.Text", "Page " + (page + 1) + "/" + totalPages);
        if (history != null && total != 0) {
            int start = page * pageSize;
            int end = Math.min(start + pageSize, total);
            for (int i = start; i < end; ++i) {
                TransactionData tx = history.get(i);
                int idx = i - start;
                String txText = String.format("[%s] %s %.2f: %s", tx.getType(), tx.getSender() != null && tx.getSender().equals(targetUuid) ? "-" : "+", tx.getAmount().doubleValue(), tx.getDescription());
                String selector = "#TransactionsList[" + idx + "]";
                builder.append("#TransactionsList", "Minerva/ReportEntry.ui");
                builder.set(selector + ".Text", txText);
            }
        } else {
            builder.append("#TransactionsList", "Minerva/ReportEntry.ui");
            builder.set("#TransactionsList[0].Text", "No transactions found.");
        }
        eventBuilder.addEventBinding(CustomUIEventBindingType.Activating, "#TransactionsBackButton", new EventData().append("Action", "view_player").append("TargetUuid", targetUuid.toString()), false);
        builder.set("#TransactionsPrev.Visible", page > 0);
        if (page > 0) {
            eventBuilder.addEventBinding(CustomUIEventBindingType.Activating, "#TransactionsPrev", new EventData().append("Action", "transactions_prev").append("TargetUuid", targetUuid.toString()).append("Page", String.valueOf(page - 1)), false);
        }
        builder.set("#TransactionsNext.Visible", page < totalPages - 1);
        if (page < totalPages - 1) {
            eventBuilder.addEventBinding(CustomUIEventBindingType.Activating, "#TransactionsNext", new EventData().append("Action", "transactions_next").append("TargetUuid", targetUuid.toString()).append("Page", String.valueOf(page + 1)), false);
        }
    }

    private void buildHistory(UICommandBuilder builder, UIEventBuilder eventBuilder) {
        this.buildHistory(builder, eventBuilder, 0);
    }

    private void buildHistory(UICommandBuilder builder, UIEventBuilder eventBuilder, int page) {
        List<ReportsData> reports;
        this.hideAllContainers(builder);
        builder.set("#DashboardHistoryTabArea.Visible", true);
        builder.clear("#HistoryTabList");
        builder.set("#DashboardTitle.Text", "Staff Dashboard - History");
        try {
            reports = ReportsDataService.getReports(false);
        }
        catch (Exception var16) {
            return;
        }
        int total = reports != null ? reports.size() : 0;
        int pageSize = 6;
        int totalPages = Math.max(1, (int)Math.ceil((double)total / (double)pageSize));
        if (page < 0) {
            page = 0;
        }
        if (page >= totalPages) {
            page = totalPages - 1;
        }
        builder.set("#HistoryTabPageLabel.Text", "Page " + (page + 1) + "/" + totalPages);
        if (reports != null && total > 0) {
            int start = page * pageSize;
            int end = Math.min(start + pageSize, total);
            for (int i = start; i < end; ++i) {
                ReportsData report = reports.get(i);
                int idx = i - start;
                String selector = "#HistoryTabList[" + idx + "]";
                builder.append("#HistoryTabList", "Minerva/ReportEntry.ui");
                PlayerData reported = PlayerDataService.getByUUID(report.getReportedUuid());
                String reportedName = reported != null ? reported.getDisplayName() : report.getReportedUuid().toString();
                builder.set(selector + ".Text", "[RESOLVED] " + reportedName + " (" + report.getTimestamp() + ")");
                eventBuilder.addEventBinding(CustomUIEventBindingType.Activating, selector, new EventData().append("Action", "view_report").append("ReportId", String.valueOf(report.getId())), false);
            }
        }
        builder.set("#HistoryTabPrev.Visible", page > 0);
        if (page > 0) {
            eventBuilder.addEventBinding(CustomUIEventBindingType.Activating, "#HistoryTabPrev", new EventData().append("Action", "history_tab_prev").append("Page", String.valueOf(page - 1)), false);
        }
        builder.set("#HistoryTabNext.Visible", page < totalPages - 1);
        if (page < totalPages - 1) {
            eventBuilder.addEventBinding(CustomUIEventBindingType.Activating, "#HistoryTabNext", new EventData().append("Action", "history_tab_next").append("Page", String.valueOf(page + 1)), false);
        }
    }

    private void buildPlayerHistoryPage(UICommandBuilder builder, UIEventBuilder eventBuilder, UUID targetUuid, int page) {
        List<ModerationHistoryData> history;
        this.hideAllContainers(builder);
        builder.set("#DashboardHistoryArea.Visible", true);
        builder.clear("#HistoryList");
        builder.set("#HistoryTitle.Text", "Moderation History");
        try {
            history = ModerationDataService.getModerationHistory(targetUuid);
        }
        catch (Exception var17) {
            return;
        }
        int total = history != null ? history.size() : 0;
        int pageSize = 5;
        int totalPages = Math.max(1, (int)Math.ceil((double)total / (double)pageSize));
        if (page < 0) {
            page = 0;
        }
        if (page >= totalPages) {
            page = totalPages - 1;
        }
        builder.set("#HistoryPageLabel.Text", "Page " + (page + 1) + "/" + totalPages);
        if (history != null && total > 0) {
            SimpleDateFormat sdf = new SimpleDateFormat("dd.MM.yyyy HH:mm");
            int start = page * pageSize;
            int end = Math.min(start + pageSize, total);
            for (int i = start; i < end; ++i) {
                ModerationHistoryData h2 = history.get(i);
                int idx = i - start;
                builder.append("#HistoryList", "Minerva/ReasonEntry.ui");
                String expiry = h2.getExpiry() != null ? " (Expires: " + sdf.format(new Date(h2.getExpiry() * 1000L)) + ")" : "";
                String active = h2.isActive() ? "[ACTIVE] " : "";
                builder.set("#HistoryList[" + idx + "] #ReasonName.Text", active + h2.getType() + ": " + h2.getCustomReason() + " - " + sdf.format(new Date(h2.getTimestamp() * 1000L)) + expiry);
                builder.set("#HistoryList[" + idx + "] #ToggleButton.Visible", false);
                builder.set("#HistoryList[" + idx + "] #DeleteButton.Visible", false);
            }
        }
        eventBuilder.addEventBinding(CustomUIEventBindingType.Activating, "#HistoryBackButton", new EventData().append("Action", "view_player").append("TargetUuid", targetUuid.toString()), false);
        builder.set("#HistoryPrev.Visible", page > 0);
        if (page > 0) {
            eventBuilder.addEventBinding(CustomUIEventBindingType.Activating, "#HistoryPrev", new EventData().append("Action", "history_prev").append("HistoryTargetUuid", targetUuid.toString()).append("Page", String.valueOf(page - 1)), false);
        }
        builder.set("#HistoryNext.Visible", page < totalPages - 1);
        if (page < totalPages - 1) {
            eventBuilder.addEventBinding(CustomUIEventBindingType.Activating, "#HistoryNext", new EventData().append("Action", "history_next").append("HistoryTargetUuid", targetUuid.toString()).append("Page", String.valueOf(page + 1)), false);
        }
    }

    private void buildSettings(UICommandBuilder builder, UIEventBuilder eventBuilder) {
        this.hideAllContainers(builder);
        builder.set("#DashboardSettingsArea.Visible", true);
        builder.clear("#SettingsContent");
        boolean auto = DutyDataService.isAutoDuty(this.playerRef.getUuid());
        builder.append("#SettingsContent", "Minerva/ReasonEntry.ui");
        builder.set("#SettingsContent[0] #ReasonName.Text", "Auto Duty: " + (auto ? "Enabled" : "Disabled"));
        builder.set("#SettingsContent[0] #ToggleButton.Text", auto ? "Disable" : "Enable");
        builder.set("#SettingsContent[0] #DeleteButton.Visible", false);
        eventBuilder.addEventBinding(CustomUIEventBindingType.Activating, "#SettingsContent[0] #ToggleButton", new EventData().append("Action", "toggle_auto_duty"), false);
    }

    private void buildReportDetails(UICommandBuilder builder, UIEventBuilder eventBuilder, int reportId) {
        ReportsData report;
        this.hideAllContainers(builder);
        builder.set("#DashboardDetailsArea.Visible", true);
        builder.clear("#DetailsContent");
        try {
            report = ReportsDataService.getById(reportId);
        }
        catch (Exception var8) {
            builder.set("#DetailsTitle.Text", Langs.minerva().dashboardErrorLoadingReport());
            return;
        }
        if (report == null) {
            builder.set("#DetailsTitle.Text", Langs.minerva().dashboardReportNotFound());
        } else {
            PlayerData reported = PlayerDataService.getByUUID(report.getReportedUuid());
            PlayerData reporter = PlayerDataService.getByUUID(report.getReporterUuid());
            builder.set("#DetailsTitle.Text", "Report #" + reportId);
            builder.append("#DetailsContent", "Minerva/ReasonEntry.ui");
            Object var10002 = reported != null ? reported.getDisplayName() : report.getReportedUuid();
            builder.set("#DetailsContent[0] #ReasonName.Text", "Reported: " + String.valueOf(var10002));
            builder.set("#DetailsContent[0] #ToggleButton.Visible", false);
            builder.set("#DetailsContent[0] #DeleteButton.Visible", false);
            builder.append("#DetailsContent", "Minerva/ReasonEntry.ui");
            var10002 = reporter != null ? reporter.getDisplayName() : report.getReporterUuid();
            builder.set("#DetailsContent[1] #ReasonName.Text", "Reporter: " + String.valueOf(var10002));
            builder.set("#DetailsContent[1] #ToggleButton.Visible", false);
            builder.set("#DetailsContent[1] #DeleteButton.Visible", false);
            builder.append("#DetailsContent", "Minerva/ReasonEntry.ui");
            builder.set("#DetailsContent[2] #ReasonName.Text", "Comment: " + report.getComment());
            builder.set("#DetailsContent[2] #ToggleButton.Visible", false);
            builder.set("#DetailsContent[2] #DeleteButton.Visible", false);
            if (report.getStaffUuid() != null) {
                builder.append("#DetailsContent", "Minerva/ReasonEntry.ui");
                PlayerData staff = PlayerDataService.getByUUID(report.getStaffUuid());
                var10002 = staff != null ? staff.getDisplayName() : report.getStaffUuid();
                builder.set("#DetailsContent[3] #ReasonName.Text", "Handled by: " + String.valueOf(var10002));
                builder.set("#DetailsContent[3] #ToggleButton.Visible", false);
                builder.set("#DetailsContent[3] #DeleteButton.Visible", false);
            }
            if (report.getStatus() == 0) {
                builder.set("#DetailsAction.Visible", true);
                builder.set("#DetailsAction.Text", "Accept");
                eventBuilder.addEventBinding(CustomUIEventBindingType.Activating, "#DetailsAction", new EventData().append("Action", "accept_report").append("ReportId", String.valueOf(reportId)), false);
            } else if (report.getStatus() == 1) {
                if (this.playerRef.getUuid().equals(report.getStaffUuid())) {
                    builder.set("#DetailsTeleport.Visible", true);
                    eventBuilder.addEventBinding(CustomUIEventBindingType.Activating, "#DetailsTeleport", new EventData().append("Action", "teleport_report").append("ReportId", String.valueOf(reportId)), false);
                    builder.set("#DetailsRelease.Visible", true);
                    eventBuilder.addEventBinding(CustomUIEventBindingType.Activating, "#DetailsRelease", new EventData().append("Action", "release_report").append("ReportId", String.valueOf(reportId)), false);
                    builder.set("#DetailsAction.Visible", true);
                    builder.set("#DetailsAction.Text", "Close Report");
                    builder.set("#DetailsClosingArea.Visible", true);
                    eventBuilder.addEventBinding(CustomUIEventBindingType.Activating, "#DetailsAction", new EventData().append("Action", "close_report").append("ReportId", String.valueOf(reportId)).append("@CloseComment", "#CloseCommentInput.Value"), false);
                } else {
                    builder.set("#DetailsAction.Visible", true);
                    builder.set("#DetailsAction.Text", "Take Over");
                    eventBuilder.addEventBinding(CustomUIEventBindingType.Activating, "#DetailsAction", new EventData().append("Action", "accept_report").append("ReportId", String.valueOf(reportId)), false);
                }
            }
            eventBuilder.addEventBinding(CustomUIEventBindingType.Activating, "#DetailsBackButton", new EventData().append("Action", "switch_tab").append("Tab", "reports"), false);
        }
    }

    private void buildFederalBank(UICommandBuilder builder, UIEventBuilder eventBuilder) {
        this.hideAllContainers(builder);
        builder.set("#FederalBankArea.Visible", true);
        builder.set("#DashboardTitle.Text", "Staff Dashboard - Federal Bank");
        builder.clear("#FederalBankList");
        List<StockDataService.FederalBankAction> actions = StockDataService.getFederalBankActions();
        if (actions.isEmpty()) {
            builder.append("#FederalBankList", "Minerva/ReportEntry.ui");
            builder.set("#FederalBankList[0].Text", "No bank actions logged.");
        } else {
            SimpleDateFormat sdf = new SimpleDateFormat("dd.MM HH:mm:ss");
            for (int i = 0; i < actions.size(); ++i) {
                StockDataService.FederalBankAction action = actions.get(i);
                String text = String.format("[%s] Stock #%d: %s %d @ %.2f$", sdf.format(new Date(action.getTimestamp() * 1000L)), action.getStockId(), action.getActionType(), action.getAmount(), action.getPrice().doubleValue());
                String selector = "#FederalBankList[" + i + "]";
                builder.append("#FederalBankList", "Minerva/ReportEntry.ui");
                builder.set(selector + ".Text", text);
            }
        }
    }

    private void hideAllContainers(UICommandBuilder builder) {
        try {
            builder.set("#DashboardTitle.Text", "Staff Dashboard");
            builder.set("#DashboardReportListArea.Visible", false);
            builder.set("#DashboardHistoryTabArea.Visible", false);
            builder.set("#DashboardDutyList.Visible", false);
            builder.set("#DashboardPlayerList.Visible", false);
            builder.set("#DashboardReasonsControls.Visible", false);
            builder.set("#DashboardReasonsListArea.Visible", false);
            builder.set("#DashboardDetailsArea.Visible", false);
            builder.set("#DashboardTransactionsArea.Visible", false);
            builder.set("#DashboardHistoryArea.Visible", false);
            builder.set("#DashboardSettingsArea.Visible", false);
            builder.set("#DetailsAction.Visible", false);
            builder.set("#DetailsTransactions.Visible", false);
            builder.set("#DetailsTeleport.Visible", false);
            builder.set("#DetailsRelease.Visible", false);
            builder.set("#DetailsUnban.Visible", false);
            builder.set("#DetailsUnmute.Visible", false);
            builder.set("#DetailsClosingArea.Visible", false);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void handleDataEvent(Ref<EntityStore> ref, Store<EntityStore> store, StaffDashboardPageEventData data) {
        try {
            Player player = (Player)store.getComponent(ref, Player.getComponentType());
            if (data.action == null || "close".equals(data.action)) {
                this.close();
                return;
            }
            if (("reports_prev".equals(data.action) || "reports_next".equals(data.action)) && data.page != null) {
                UICommandBuilder builder = new UICommandBuilder();
                UIEventBuilder eventBuilder = new UIEventBuilder();
                int page = 0;
                try {
                    page = Integer.parseInt(data.page);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
                this.buildReports(builder, eventBuilder, page);
                this.sendUpdate(builder, eventBuilder, false);
                return;
            }
            if (("history_tab_prev".equals(data.action) || "history_tab_next".equals(data.action)) && data.page != null) {
                UICommandBuilder builder = new UICommandBuilder();
                UIEventBuilder eventBuilder = new UIEventBuilder();
                int page = 0;
                try {
                    page = Integer.parseInt(data.page);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
                this.buildHistory(builder, eventBuilder, page);
                this.sendUpdate(builder, eventBuilder, false);
                return;
            }
            if (("reasons_prev".equals(data.action) || "reasons_next".equals(data.action)) && data.page != null) {
                UICommandBuilder builder = new UICommandBuilder();
                UIEventBuilder eventBuilder = new UIEventBuilder();
                int page = 0;
                try {
                    page = Integer.parseInt(data.page);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
                this.buildReasons(builder, eventBuilder, page);
                this.sendUpdate(builder, eventBuilder, false);
                return;
            }
            if ("view_report".equals(data.action) && data.reportId != null) {
                if (!player.hasPermission("serverrocket.minerva.dashboard.reports")) {
                    String var121 = PrefixManager.serverrocket();
                    player.sendMessage(Message.raw((String)(var121 + " " + Langs.serverrocket().noPermission())));
                    return;
                }
                UICommandBuilder builder = new UICommandBuilder();
                UIEventBuilder eventBuilder = new UIEventBuilder();
                this.buildReportDetails(builder, eventBuilder, Integer.parseInt(data.reportId));
                this.sendUpdate(builder, eventBuilder, false);
                return;
            }
            if ("accept_report".equals(data.action) && data.reportId != null) {
                if (!player.hasPermission("serverrocket.minerva.dashboard.reports.manage")) {
                    String var120 = PrefixManager.serverrocket();
                    player.sendMessage(Message.raw((String)(var120 + " " + Langs.serverrocket().noPermission())));
                    return;
                }
                int reportId = Integer.parseInt(data.reportId);
                ReportsDataService.updateReportStatus(reportId, this.playerRef.getUuid(), 1);
                player.sendMessage(Message.raw((String)String.format(Langs.minerva().dashboardReportAccepted(), reportId)));
                UICommandBuilder builder = new UICommandBuilder();
                UIEventBuilder eventBuilder = new UIEventBuilder();
                this.buildReportDetails(builder, eventBuilder, reportId);
                this.sendUpdate(builder, eventBuilder, false);
                return;
            }
            if ("release_report".equals(data.action) && data.reportId != null) {
                if (!player.hasPermission("serverrocket.minerva.dashboard.reports.manage")) {
                    String var119 = PrefixManager.serverrocket();
                    player.sendMessage(Message.raw((String)(var119 + " " + Langs.serverrocket().noPermission())));
                    return;
                }
                int reportId = Integer.parseInt(data.reportId);
                ReportsDataService.updateReportStatus(reportId, null, 0);
                player.sendMessage(Message.raw((String)String.format(Langs.minerva().dashboardReportReleased(), reportId)));
                UICommandBuilder builder = new UICommandBuilder();
                UIEventBuilder eventBuilder = new UIEventBuilder();
                this.buildReportDetails(builder, eventBuilder, reportId);
                this.sendUpdate(builder, eventBuilder, false);
                return;
            }
            if ("teleport_report".equals(data.action) && data.reportId != null) {
                int reportId = Integer.parseInt(data.reportId);
                ReportsData report = ReportsDataService.getById(reportId);
                if (report != null) {
                    String targetName = report.getSourceServer();
                    ServerRocketConfig.NetworkConfig net = Configs.serverrocket().getNetwork();
                    if (targetName != null && !targetName.isEmpty() && !targetName.equalsIgnoreCase(net.getCurrentServer())) {
                        List<ServerRocketConfig.ServerInfo> servers = net.getServers();
                        ServerRocketConfig.ServerInfo target = null;
                        if (servers != null) {
                            for (ServerRocketConfig.ServerInfo s2 : servers) {
                                if (!s2.getName().equalsIgnoreCase(targetName)) continue;
                                target = s2;
                                break;
                            }
                        }
                        if (target != null) {
                            this.playerRef.referToServer(target.getHost(), target.getPort());
                            player.sendMessage(Message.raw((String)String.format(Langs.minerva().dashboardTransferring(), targetName)));
                        } else {
                            player.sendMessage(Message.raw((String)String.format(Langs.minerva().dashboardServerNotFound(), targetName)));
                        }
                    } else {
                        player.sendMessage(Message.raw((String)Langs.minerva().dashboardAlreadyOnServer()));
                    }
                }
                return;
            }
            if ("view_history".equals(data.action) && data.targetUuid != null) {
                UICommandBuilder builder = new UICommandBuilder();
                UIEventBuilder eventBuilder = new UIEventBuilder();
                UUID target = UUID.fromString(data.targetUuid);
                int page = 0;
                try {
                    if (data.page != null) {
                        page = Integer.parseInt(data.page);
                    }
                }
                catch (NumberFormatException servers) {
                    // empty catch block
                }
                this.buildPlayerHistoryPage(builder, eventBuilder, target, page);
                this.sendUpdate(builder, eventBuilder, false);
                return;
            }
            if (("history_prev".equals(data.action) || "history_next".equals(data.action)) && data.historyTargetUuid != null) {
                UICommandBuilder builder = new UICommandBuilder();
                UIEventBuilder eventBuilder = new UIEventBuilder();
                UUID target = UUID.fromString(data.historyTargetUuid);
                int page2 = 0;
                try {
                    if (data.page != null) {
                        page2 = Integer.parseInt(data.page);
                    }
                }
                catch (NumberFormatException servers) {
                    // empty catch block
                }
                this.buildPlayerHistoryPage(builder, eventBuilder, target, page2);
                this.sendUpdate(builder, eventBuilder, false);
                return;
            }
            if ("duty_prev".equals(data.action) || "duty_next".equals(data.action) || "players_prev".equals(data.action) || "players_next".equals(data.action)) {
                UICommandBuilder builder = new UICommandBuilder();
                UIEventBuilder eventBuilder = new UIEventBuilder();
                int page = 0;
                try {
                    if (data.page != null) {
                        page = Integer.parseInt(data.page);
                    }
                }
                catch (NumberFormatException page2) {
                    // empty catch block
                }
                if (data.action.startsWith("duty")) {
                    this.buildDuty(builder, eventBuilder, page);
                } else {
                    this.buildPlayers(builder, eventBuilder, page);
                }
                this.sendUpdate(builder, eventBuilder, false);
                return;
            }
            if ("toggle_auto_duty".equals(data.action)) {
                if (!player.hasPermission("serverrocket.minerva.duty")) {
                    String var118 = PrefixManager.serverrocket();
                    player.sendMessage(Message.raw((String)(var118 + " " + Langs.serverrocket().noPermission())));
                    return;
                }
                boolean current = DutyDataService.isAutoDuty(this.playerRef.getUuid());
                DutyDataService.setAutoDuty(this.playerRef.getUuid(), !current);
                UICommandBuilder builder = new UICommandBuilder();
                UIEventBuilder eventBuilder = new UIEventBuilder();
                this.buildSettings(builder, eventBuilder);
                this.sendUpdate(builder, eventBuilder, false);
                return;
            }
            if ("close_report".equals(data.action) && data.reportId != null) {
                if (!player.hasPermission("serverrocket.minerva.dashboard.reports.manage")) {
                    String var117 = PrefixManager.serverrocket();
                    player.sendMessage(Message.raw((String)(var117 + " " + Langs.serverrocket().noPermission())));
                    return;
                }
                int reportId = Integer.parseInt(data.reportId);
                ReportsDataService.closeReport(reportId, this.playerRef.getUuid(), data.closeComment);
                player.sendMessage(Message.raw((String)String.format(Langs.minerva().dashboardReportClosed(), reportId)));
                UICommandBuilder builder = new UICommandBuilder();
                UIEventBuilder eventBuilder = new UIEventBuilder();
                this.buildReports(builder, eventBuilder);
                this.sendUpdate(builder, eventBuilder, false);
                return;
            }
            if ("resolve_report".equals(data.action) && data.reportId != null) {
                data.action = "accept_report";
                this.handleDataEvent(ref, store, data);
                return;
            }
            if ("view_player".equals(data.action) && data.targetUuid != null) {
                if (!player.hasPermission("serverrocket.minerva.dashboard.players")) {
                    String var116 = PrefixManager.serverrocket();
                    player.sendMessage(Message.raw((String)(var116 + " " + Langs.serverrocket().noPermission())));
                    return;
                }
                UICommandBuilder builder = new UICommandBuilder();
                UIEventBuilder eventBuilder = new UIEventBuilder();
                this.buildPlayerDetails(builder, eventBuilder, UUID.fromString(data.targetUuid));
                this.sendUpdate(builder, eventBuilder, false);
                return;
            }
            if ("view_transactions".equals(data.action) && data.targetUuid != null) {
                if (!player.hasPermission("serverrocket.minerva.dashboard.players")) {
                    String var115 = PrefixManager.serverrocket();
                    player.sendMessage(Message.raw((String)(var115 + " " + Langs.serverrocket().noPermission())));
                    return;
                }
                UICommandBuilder builder = new UICommandBuilder();
                UIEventBuilder eventBuilder = new UIEventBuilder();
                int page = 0;
                try {
                    if (data.page != null) {
                        page = Integer.parseInt(data.page);
                    }
                }
                catch (NumberFormatException page2) {
                    // empty catch block
                }
                this.buildPlayerTransactionsPage(builder, eventBuilder, UUID.fromString(data.targetUuid), page);
                this.sendUpdate(builder, eventBuilder, false);
                return;
            }
            if (("transactions_prev".equals(data.action) || "transactions_next".equals(data.action)) && data.targetUuid != null) {
                UICommandBuilder builder = new UICommandBuilder();
                UIEventBuilder eventBuilder = new UIEventBuilder();
                UUID target = UUID.fromString(data.targetUuid);
                int page = 0;
                try {
                    if (data.page != null) {
                        page = Integer.parseInt(data.page);
                    }
                }
                catch (NumberFormatException servers) {
                    // empty catch block
                }
                this.buildPlayerTransactionsPage(builder, eventBuilder, target, page);
                this.sendUpdate(builder, eventBuilder, false);
                return;
            }
            if ("unban_player".equals(data.action) && data.targetUuid != null) {
                if (!player.hasPermission("serverrocket.minerva.ban")) {
                    String var114 = PrefixManager.serverrocket();
                    player.sendMessage(Message.raw((String)(var114 + " " + Langs.serverrocket().noPermission())));
                    return;
                }
                UUID targetUuid = UUID.fromString(data.targetUuid);
                ModerationDataService.deactivateModeration(targetUuid, "BAN");
                PlayerData targetData = PlayerDataService.getByUUID(targetUuid);
                String targetName = targetData != null ? targetData.getDisplayName() : data.targetUuid;
                player.sendMessage(Message.raw((String)String.format(Langs.minerva().dashboardUnbanSuccess(), targetName)));
                UICommandBuilder builder = new UICommandBuilder();
                UIEventBuilder eventBuilder = new UIEventBuilder();
                this.buildPlayerDetails(builder, eventBuilder, targetUuid);
                this.sendUpdate(builder, eventBuilder, false);
                return;
            }
            if ("unmute_player".equals(data.action) && data.targetUuid != null) {
                if (!player.hasPermission("serverrocket.minerva.mute")) {
                    String var113 = PrefixManager.serverrocket();
                    player.sendMessage(Message.raw((String)(var113 + " " + Langs.serverrocket().noPermission())));
                    return;
                }
                UUID targetUuid = UUID.fromString(data.targetUuid);
                ModerationDataService.deactivateModeration(targetUuid, "MUTE");
                PlayerData targetData = PlayerDataService.getByUUID(targetUuid);
                String targetName = targetData != null ? targetData.getDisplayName() : data.targetUuid;
                player.sendMessage(Message.raw((String)String.format(Langs.minerva().dashboardUnmuteSuccess(), targetName)));
                UICommandBuilder builder2 = new UICommandBuilder();
                UIEventBuilder eventBuilder = new UIEventBuilder();
                this.buildPlayerDetails(builder2, eventBuilder, targetUuid);
                this.sendUpdate(builder2, eventBuilder, false);
                return;
            }
            if ("switch_tab".equals(data.action) && data.tab != null) {
                UICommandBuilder builder = new UICommandBuilder();
                UIEventBuilder eventBuilder = new UIEventBuilder();
                if ("reports".equals(data.tab)) {
                    if (!player.hasPermission("serverrocket.minerva.dashboard.reports")) {
                        String var107 = PrefixManager.serverrocket();
                        player.sendMessage(Message.raw((String)(var107 + " " + Langs.serverrocket().noPermission())));
                        return;
                    }
                    this.buildReports(builder, eventBuilder);
                } else if ("duty".equals(data.tab)) {
                    if (!player.hasPermission("serverrocket.minerva.duty")) {
                        String var108 = PrefixManager.serverrocket();
                        player.sendMessage(Message.raw((String)(var108 + " " + Langs.serverrocket().noPermission())));
                        return;
                    }
                    int page = 0;
                    try {
                        if (data.page != null) {
                            page = Integer.parseInt(data.page);
                        }
                    }
                    catch (NumberFormatException builder2) {
                        // empty catch block
                    }
                    this.buildDuty(builder, eventBuilder, page);
                } else if ("players".equals(data.tab)) {
                    if (!player.hasPermission("serverrocket.minerva.dashboard.players")) {
                        String var109 = PrefixManager.serverrocket();
                        player.sendMessage(Message.raw((String)(var109 + " " + Langs.serverrocket().noPermission())));
                        return;
                    }
                    int page = 0;
                    try {
                        if (data.page != null) {
                            page = Integer.parseInt(data.page);
                        }
                    }
                    catch (NumberFormatException builder2) {
                        // empty catch block
                    }
                    this.buildPlayers(builder, eventBuilder, page);
                } else if ("reasons".equals(data.tab)) {
                    if (!player.hasPermission("serverrocket.minerva.dashboard.reasons")) {
                        String var110 = PrefixManager.serverrocket();
                        player.sendMessage(Message.raw((String)(var110 + " " + Langs.serverrocket().noPermission())));
                        return;
                    }
                    int page = 0;
                    try {
                        if (data.page != null) {
                            page = Integer.parseInt(data.page);
                        }
                    }
                    catch (NumberFormatException builder2) {
                        // empty catch block
                    }
                    this.buildReasons(builder, eventBuilder, page);
                } else if ("history".equals(data.tab)) {
                    if (!player.hasPermission("serverrocket.minerva.dashboard.reports.history")) {
                        String var111 = PrefixManager.serverrocket();
                        player.sendMessage(Message.raw((String)(var111 + " " + Langs.serverrocket().noPermission())));
                        return;
                    }
                    int page = 0;
                    try {
                        if (data.page != null) {
                            page = Integer.parseInt(data.page);
                        }
                    }
                    catch (NumberFormatException builder2) {
                        // empty catch block
                    }
                    this.buildHistory(builder, eventBuilder, page);
                } else {
                    if (!"settings".equals(data.tab)) {
                        if (player != null) {
                            player.sendMessage(Message.raw((String)("Tab " + data.tab + " is not yet implemented.")));
                        }
                        return;
                    }
                    if (!player.hasPermission("serverrocket.minerva.duty")) {
                        String var112 = PrefixManager.serverrocket();
                        player.sendMessage(Message.raw((String)(var112 + " " + Langs.serverrocket().noPermission())));
                        return;
                    }
                    this.buildSettings(builder, eventBuilder);
                }
                this.sendUpdate(builder, eventBuilder, false);
                return;
            }
            if ("select_reason_type".equals(data.action) && data.reasonType != null) {
                this.selectedReasonType = data.reasonType;
                UICommandBuilder builder = new UICommandBuilder();
                UIEventBuilder eventBuilder = new UIEventBuilder();
                this.buildReasons(builder, eventBuilder, 0);
                this.sendUpdate(builder, eventBuilder, false);
                return;
            }
            if ("add_reason".equals(data.action) && data.reasonName != null && data.reasonPriority != null) {
                if (!player.hasPermission("serverrocket.minerva.dashboard.reasons")) {
                    String var106 = PrefixManager.serverrocket();
                    player.sendMessage(Message.raw((String)(var106 + " " + Langs.serverrocket().noPermission())));
                    return;
                }
                String type = data.reasonType != null ? data.reasonType : "REPORT";
                try {
                    int priority = Integer.parseInt(data.reasonPriority);
                    if ("REPORT".equals(type)) {
                        if (ReportsReasonDataService.exists(data.reasonName)) {
                            player.sendMessage(Message.raw((String)String.format(Langs.minerva().dashboardReasonAlreadyExists(), data.reasonName)));
                        } else {
                            ReportsReasonDataService.addReason(data.reasonName, "", priority);
                            player.sendMessage(Message.raw((String)String.format(Langs.minerva().dashboardReasonAdded(), data.reasonName)));
                        }
                    } else if (ModerationDataService.exists(data.reasonName)) {
                        player.sendMessage(Message.raw((String)String.format(Langs.minerva().dashboardReasonAlreadyExists(), data.reasonName)));
                    } else {
                        Integer duration = this.parseDurationString(data.reasonDuration);
                        ModerationDataService.addModerationReason(type, data.reasonName, duration);
                        player.sendMessage(Message.raw((String)String.format(Langs.minerva().dashboardReasonAdded(), data.reasonName)));
                    }
                }
                catch (NumberFormatException var15) {
                    player.sendMessage(Message.raw((String)"Invalid priority value."));
                }
                UICommandBuilder builder = new UICommandBuilder();
                UIEventBuilder eventBuilder = new UIEventBuilder();
                int page = 0;
                try {
                    if (data.page != null) {
                        page = Integer.parseInt(data.page);
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
                this.buildReasons(builder, eventBuilder, page);
                this.sendUpdate(builder, eventBuilder, false);
                return;
            }
            if ("toggle_reason".equals(data.action) && data.reasonName != null) {
                String type;
                if (!player.hasPermission("serverrocket.minerva.dashboard.reasons")) {
                    String var105 = PrefixManager.serverrocket();
                    player.sendMessage(Message.raw((String)(var105 + " " + Langs.serverrocket().noPermission())));
                    return;
                }
                String string = type = data.reasonType != null ? data.reasonType : "REPORT";
                if ("REPORT".equals(type)) {
                    reason = ReportsReasonDataService.getByName(data.reasonName);
                    if (reason != null) {
                        newStatus = ((ReportsReasonData)reason).getStatus() == 1 ? 0 : 1;
                        ReportsReasonDataService.setStatus(data.reasonName, newStatus);
                        player.sendMessage(Message.raw((String)String.format(Langs.minerva().dashboardReasonToggled(), data.reasonName)));
                    }
                } else {
                    reason = ModerationDataService.getReasonByName(data.reasonName);
                    if (reason != null) {
                        newStatus = ((ModerationReasonData)reason).getStatus() == 1 ? 0 : 1;
                        ModerationDataService.setStatus(data.reasonName, newStatus);
                        player.sendMessage(Message.raw((String)String.format(Langs.minerva().dashboardReasonToggled(), data.reasonName)));
                    }
                }
                UICommandBuilder builder = new UICommandBuilder();
                UIEventBuilder eventBuilder = new UIEventBuilder();
                int page = 0;
                try {
                    if (data.page != null) {
                        page = Integer.parseInt(data.page);
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
                this.buildReasons(builder, eventBuilder, page);
                this.sendUpdate(builder, eventBuilder, false);
                return;
            }
            if ("delete_reason".equals(data.action) && data.reasonName != null) {
                String type;
                if (!player.hasPermission("serverrocket.minerva.dashboard.reasons")) {
                    String var10001 = PrefixManager.serverrocket();
                    player.sendMessage(Message.raw((String)(var10001 + " " + Langs.serverrocket().noPermission())));
                    return;
                }
                String string = type = data.reasonType != null ? data.reasonType : "REPORT";
                if ("REPORT".equals(type)) {
                    if (ReportsReasonDataService.hasReports(data.reasonName)) {
                        player.sendMessage(Message.raw((String)String.format(Langs.minerva().reportsreasonCannotRemoveHasReports(), data.reasonName)));
                    } else {
                        ReportsReasonDataService.removeReason(data.reasonName);
                        player.sendMessage(Message.raw((String)String.format(Langs.minerva().dashboardReasonDeleted(), data.reasonName)));
                    }
                } else if (ModerationDataService.hasModerations(data.reasonName)) {
                    player.sendMessage(Message.raw((String)String.format(Langs.minerva().dashboardReasonCannotDeleteHistory(), data.reasonName)));
                } else {
                    ModerationDataService.removeModerationReason(data.reasonName);
                    player.sendMessage(Message.raw((String)String.format(Langs.minerva().dashboardReasonDeleted(), data.reasonName)));
                }
                this.refreshReasonsTab();
                return;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private Integer parseDurationString(String input) {
        if (!(input == null || input.isEmpty() || input.equals("0") || input.equalsIgnoreCase("permanent"))) {
            try {
                int value = Integer.parseInt(input.replaceAll("[^0-9]", ""));
                return switch (input.replaceAll("[0-9]", "").toLowerCase().trim()) {
                    case "m", "min", "minutes" -> value * 60;
                    case "h", "hour", "hours" -> value * 3600;
                    case "d", "day", "days" -> value * 86400;
                    case "w", "week", "weeks" -> value * 604800;
                    case "mo", "month", "months" -> value * 2592000;
                    case "y", "year", "years" -> value * 31536000;
                    default -> value;
                };
            }
            catch (Exception var6) {
                return 0;
            }
        }
        return 0;
    }

    private void refreshReasonsTab() {
        UICommandBuilder builder = new UICommandBuilder();
        UIEventBuilder eventBuilder = new UIEventBuilder();
        this.buildReasons(builder, eventBuilder);
        this.sendUpdate(builder, eventBuilder, false);
    }
}

