/*
 * Decompiled with CFR 0.152.
 */
package ch.serverrocket.stockmarket;

import ch.serverrocket.config.Configs;
import ch.serverrocket.database.economy.EconomyDataService;
import ch.serverrocket.database.stockmarket.LimitOrder;
import ch.serverrocket.database.stockmarket.PlayerStockData;
import ch.serverrocket.database.stockmarket.StockData;
import ch.serverrocket.database.stockmarket.StockDataService;
import ch.serverrocket.lang.Langs;
import ch.serverrocket.messages.PrefixManager;
import ch.serverrocket.stockmarket.StockMarketPageEventData;
import com.hypixel.hytale.component.Ref;
import com.hypixel.hytale.component.Store;
import com.hypixel.hytale.protocol.packets.interface_.CustomPageLifetime;
import com.hypixel.hytale.protocol.packets.interface_.CustomUIEventBindingType;
import com.hypixel.hytale.server.core.Message;
import com.hypixel.hytale.server.core.entity.entities.Player;
import com.hypixel.hytale.server.core.entity.entities.player.pages.CustomUIPage;
import com.hypixel.hytale.server.core.entity.entities.player.pages.InteractiveCustomUIPage;
import com.hypixel.hytale.server.core.ui.builder.EventData;
import com.hypixel.hytale.server.core.ui.builder.UICommandBuilder;
import com.hypixel.hytale.server.core.ui.builder.UIEventBuilder;
import com.hypixel.hytale.server.core.universe.PlayerRef;
import com.hypixel.hytale.server.core.universe.world.storage.EntityStore;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;

public class StockMarketPage
extends InteractiveCustomUIPage<StockMarketPageEventData> {
    public static final String LAYOUT = "Minerva/StockMarket.ui";
    private final PlayerRef playerRef;
    private String currentTab = "stocks";
    private final Map<UUID, Long> tradeCooldowns = new HashMap<UUID, Long>();

    public StockMarketPage(PlayerRef playerRef) {
        super(playerRef, CustomPageLifetime.CanDismiss, StockMarketPageEventData.CODEC);
        this.playerRef = playerRef;
    }

    public void build(Ref<EntityStore> ref, UICommandBuilder builder, UIEventBuilder eventBuilder, Store<EntityStore> store) {
        builder.append(LAYOUT);
        builder.set("#DashboardTitle.Text", Langs.stockmarket().dashboardTitle());
        eventBuilder.addEventBinding(CustomUIEventBindingType.Activating, "#TabStocks", new EventData().append("Action", "switch_tab").append("Tab", "stocks"), false);
        eventBuilder.addEventBinding(CustomUIEventBindingType.Activating, "#TabPortfolio", new EventData().append("Action", "switch_tab").append("Tab", "portfolio"), false);
        eventBuilder.addEventBinding(CustomUIEventBindingType.Activating, "#TabOwner", new EventData().append("Action", "switch_tab").append("Tab", "owner"), false);
        BigDecimal balance = EconomyDataService.getBalance(this.playerRef.getUuid());
        Object[] var10003 = new Object[]{balance.doubleValue()};
        builder.set("#BalanceLabel.Text", "Balance: " + String.format("%.2f$", var10003));
        List<StockData> myCompanies = StockDataService.getStocksByOwner(this.playerRef.getUuid());
        if (!myCompanies.isEmpty()) {
            builder.set("#TabOwner.Visible", true);
        }
        boolean page = false;
        if ("stocks".equals(this.currentTab)) {
            builder.set("#StockArea.Visible", true);
            builder.set("#PortfolioArea.Visible", false);
            builder.set("#OwnerArea.Visible", false);
            this.buildStockList(builder, eventBuilder, 0);
        } else if ("portfolio".equals(this.currentTab)) {
            builder.set("#StockArea.Visible", false);
            builder.set("#PortfolioArea.Visible", true);
            builder.set("#OwnerArea.Visible", false);
            this.buildPortfolio(builder, eventBuilder, 0);
        } else {
            builder.set("#StockArea.Visible", false);
            builder.set("#PortfolioArea.Visible", false);
            builder.set("#OwnerArea.Visible", true);
            this.buildOwnerPanel(builder, eventBuilder, myCompanies, 0);
        }
    }

    private void buildStockList(UICommandBuilder builder, UIEventBuilder eventBuilder, int page) {
        builder.clear("#StockList");
        List<StockData> stocks = StockDataService.getAllStocks();
        int total = stocks.size();
        int pageSize = 5;
        int totalPages = Math.max(1, (int)Math.ceil((double)total / (double)pageSize));
        if (page < 0) {
            page = 0;
        }
        if (page >= totalPages) {
            page = totalPages - 1;
        }
        builder.set("#StockPageLabel.Text", "Page " + (page + 1) + "/" + totalPages);
        int start = page * pageSize;
        int end = Math.min(start + pageSize, total);
        for (int i = start; i < end; ++i) {
            StockData stock = stocks.get(i);
            if (stock.getAvailableShares() <= 0) continue;
            int idx = i - start;
            String selector = "#StockList[" + idx + "]";
            builder.append("#StockList", "Minerva/ReportEntry.ui");
            String trend = "";
            if (stock.getPrice().compareTo(stock.getLastPrice()) > 0) {
                trend = " [UP]";
            } else if (stock.getPrice().compareTo(stock.getLastPrice()) < 0) {
                trend = " [DOWN]";
            }
            String text = String.format("%s (%s) - Price: %.2f$%s", stock.getName(), stock.getSymbol(), stock.getPrice().doubleValue(), trend);
            builder.set(selector + ".Text", text);
            eventBuilder.addEventBinding(CustomUIEventBindingType.Activating, selector, new EventData().append("Action", "buy_prompt").append("StockId", String.valueOf(stock.getId())), false);
        }
        builder.set("#StockPrev.Visible", page > 0);
        if (page > 0) {
            eventBuilder.addEventBinding(CustomUIEventBindingType.Activating, "#StockPrev", new EventData().append("Action", "market_prev").append("Page", String.valueOf(page - 1)), false);
        }
        builder.set("#StockNext.Visible", page < totalPages - 1);
        if (page < totalPages - 1) {
            eventBuilder.addEventBinding(CustomUIEventBindingType.Activating, "#StockNext", new EventData().append("Action", "market_next").append("Page", String.valueOf(page + 1)), false);
        }
    }

    private void buildPortfolio(UICommandBuilder builder, UIEventBuilder eventBuilder, int page) {
        builder.clear("#PortfolioList");
        List<StockData> allStocks = StockDataService.getAllStocks();
        ArrayList<StockData> ownedStocks = new ArrayList<StockData>();
        for (StockData s2 : allStocks) {
            if (StockDataService.getSharesOwned(this.playerRef.getUuid(), s2.getId()) <= 0) continue;
            ownedStocks.add(s2);
        }
        int total = ownedStocks.size();
        int pageSize = 5;
        int totalPages = Math.max(1, (int)Math.ceil((double)total / (double)pageSize));
        if (page < 0) {
            page = 0;
        }
        if (page >= totalPages) {
            page = totalPages - 1;
        }
        builder.set("#PortfolioPageLabel.Text", "Page " + (page + 1) + "/" + totalPages);
        if (total == 0) {
            builder.append("#PortfolioList", "Minerva/ReportEntry.ui");
            builder.set("#PortfolioList[0].Text", "You don't own any stocks.");
        } else {
            int start = page * pageSize;
            int end = Math.min(start + pageSize, total);
            for (int i = start; i < end; ++i) {
                StockData stock = (StockData)ownedStocks.get(i);
                PlayerStockData psd = StockDataService.getPlayerStock(this.playerRef.getUuid(), stock.getId());
                int owned = psd.getShares();
                int idx = i - start;
                String selector = "#PortfolioList[" + idx + "]";
                builder.append("#PortfolioList", "Minerva/ReportEntry.ui");
                String trend = "";
                if (stock.getPrice().compareTo(stock.getLastPrice()) > 0) {
                    trend = " [UP]";
                } else if (stock.getPrice().compareTo(stock.getLastPrice()) < 0) {
                    trend = " [DOWN]";
                }
                BigDecimal currentVal = stock.getPrice().multiply(BigDecimal.valueOf(owned));
                BigDecimal costBasis = psd.getAverageBuyPrice().multiply(BigDecimal.valueOf(owned));
                BigDecimal unrealizedPL = currentVal.subtract(costBasis);
                String text = String.format("%s (%s) - Owned: %d - Avg: %.2f$ - P/L: %.2f$%s", stock.getName(), stock.getSymbol(), owned, psd.getAverageBuyPrice().doubleValue(), unrealizedPL.doubleValue(), trend);
                builder.set(selector + ".Text", text);
                eventBuilder.addEventBinding(CustomUIEventBindingType.Activating, selector, new EventData().append("Action", "sell_prompt").append("StockId", String.valueOf(stock.getId())), false);
            }
        }
        builder.set("#PortfolioPrev.Visible", page > 0);
        if (page > 0) {
            eventBuilder.addEventBinding(CustomUIEventBindingType.Activating, "#PortfolioPrev", new EventData().append("Action", "portfolio_prev").append("Page", String.valueOf(page - 1)), false);
        }
        builder.set("#PortfolioNext.Visible", page < totalPages - 1);
        if (page < totalPages - 1) {
            eventBuilder.addEventBinding(CustomUIEventBindingType.Activating, "#PortfolioNext", new EventData().append("Action", "portfolio_next").append("Page", String.valueOf(page + 1)), false);
        }
    }

    private void buildOwnerPanel(UICommandBuilder builder, UIEventBuilder eventBuilder, List<StockData> myCompanies, int page) {
        builder.clear("#OwnerStockList");
        int total = myCompanies.size();
        int pageSize = 5;
        int totalPages = Math.max(1, (int)Math.ceil((double)total / (double)pageSize));
        if (page < 0) {
            page = 0;
        }
        if (page >= totalPages) {
            page = totalPages - 1;
        }
        builder.set("#OwnerPageLabel.Text", "Page " + (page + 1) + "/" + totalPages);
        int start = page * pageSize;
        int end = Math.min(start + pageSize, total);
        for (int i = start; i < end; ++i) {
            StockData stock = myCompanies.get(i);
            int idx = i - start;
            String selector = "#OwnerStockList[" + idx + "]";
            builder.append("#OwnerStockList", "Minerva/ReportEntry.ui");
            String text = String.format("%s (%s) - Shares: %d/%d - Price: %.2f$ [CLICK TO SPLIT]", stock.getName(), stock.getSymbol(), stock.getAvailableShares(), stock.getTotalShares(), stock.getPrice());
            builder.set(selector + ".Text", text);
            eventBuilder.addEventBinding(CustomUIEventBindingType.Activating, selector, new EventData().append("Action", "split_stock").append("StockId", String.valueOf(stock.getId())), false);
        }
        builder.set("#OwnerPrev.Visible", page > 0);
        if (page > 0) {
            eventBuilder.addEventBinding(CustomUIEventBindingType.Activating, "#OwnerPrev", new EventData().append("Action", "owner_prev").append("Page", String.valueOf(page - 1)), false);
        }
        builder.set("#OwnerNext.Visible", page < totalPages - 1);
        if (page < totalPages - 1) {
            eventBuilder.addEventBinding(CustomUIEventBindingType.Activating, "#OwnerNext", new EventData().append("Action", "owner_next").append("Page", String.valueOf(page + 1)), false);
        }
    }

    public void handleDataEvent(Ref<EntityStore> ref, Store<EntityStore> store, StockMarketPageEventData data) {
        Player player = (Player)store.getComponent(ref, Player.getComponentType());
        if (player != null) {
            if ("switch_tab".equals(data.action)) {
                this.currentTab = data.tab;
                player.getPageManager().openCustomPage(ref, store, (CustomUIPage)this);
            } else if ("buy_prompt".equals(data.action)) {
                this.handleBuy(player, Integer.parseInt(data.stockId), 1);
                player.getPageManager().openCustomPage(ref, store, (CustomUIPage)this);
            } else if ("sell_prompt".equals(data.action)) {
                this.handleSell(player, Integer.parseInt(data.stockId), 1);
                player.getPageManager().openCustomPage(ref, store, (CustomUIPage)this);
            } else if ("place_limit_buy".equals(data.action)) {
                StockDataService.createLimitOrder(Integer.parseInt(data.stockId), this.playerRef.getUuid(), LimitOrder.OrderType.BUY, 10, BigDecimal.valueOf(90L));
                player.sendMessage(Message.raw((String)(PrefixManager.stockmarket() + " Limit Buy Order placed for 10 shares at 90.00$")));
                player.getPageManager().openCustomPage(ref, store, (CustomUIPage)this);
            } else if ("place_limit_sell".equals(data.action)) {
                StockDataService.createLimitOrder(Integer.parseInt(data.stockId), this.playerRef.getUuid(), LimitOrder.OrderType.SELL, 10, BigDecimal.valueOf(110L));
                player.sendMessage(Message.raw((String)(PrefixManager.stockmarket() + " Limit Sell Order placed for 10 shares at 110.00$")));
                player.getPageManager().openCustomPage(ref, store, (CustomUIPage)this);
            } else if ("split_stock".equals(data.action)) {
                this.handleSplit(player, Integer.parseInt(data.stockId));
                player.getPageManager().openCustomPage(ref, store, (CustomUIPage)this);
            } else if (data.action != null && (data.action.endsWith("_prev") || data.action.endsWith("_next"))) {
                UICommandBuilder builder = new UICommandBuilder();
                UIEventBuilder eventBuilder = new UIEventBuilder();
                int page = 0;
                try {
                    if (data.page != null) {
                        page = Integer.parseInt(data.page);
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
                builder.append(LAYOUT);
                builder.set("#DashboardTitle.Text", Langs.stockmarket().dashboardTitle());
                eventBuilder.addEventBinding(CustomUIEventBindingType.Activating, "#TabStocks", new EventData().append("Action", "switch_tab").append("Tab", "stocks"), false);
                eventBuilder.addEventBinding(CustomUIEventBindingType.Activating, "#TabPortfolio", new EventData().append("Action", "switch_tab").append("Tab", "portfolio"), false);
                eventBuilder.addEventBinding(CustomUIEventBindingType.Activating, "#TabOwner", new EventData().append("Action", "switch_tab").append("Tab", "owner"), false);
                BigDecimal balance = EconomyDataService.getBalance(this.playerRef.getUuid());
                Object[] var10003 = new Object[]{balance.doubleValue()};
                builder.set("#BalanceLabel.Text", "Balance: " + String.format("%.2f$", var10003));
                List<StockData> myCompanies = StockDataService.getStocksByOwner(this.playerRef.getUuid());
                if (!myCompanies.isEmpty()) {
                    builder.set("#TabOwner.Visible", true);
                }
                if (data.action.startsWith("market")) {
                    builder.set("#StockArea.Visible", true);
                    builder.set("#PortfolioArea.Visible", false);
                    builder.set("#OwnerArea.Visible", false);
                    this.buildStockList(builder, eventBuilder, page);
                } else if (data.action.startsWith("portfolio")) {
                    builder.set("#StockArea.Visible", false);
                    builder.set("#PortfolioArea.Visible", true);
                    builder.set("#OwnerArea.Visible", false);
                    this.buildPortfolio(builder, eventBuilder, page);
                } else if (data.action.startsWith("owner")) {
                    builder.set("#StockArea.Visible", false);
                    builder.set("#PortfolioArea.Visible", false);
                    builder.set("#OwnerArea.Visible", true);
                    this.buildOwnerPanel(builder, eventBuilder, myCompanies, page);
                }
                this.sendUpdate(builder, eventBuilder, false);
            }
        }
    }

    private void handleSplit(Player player, int stockId) {
        StockData stock = StockDataService.getStock(stockId);
        if (stock != null && stock.getOwner() != null && stock.getOwner().equals(this.playerRef.getUuid())) {
            StockDataService.splitStock(stockId, 2, 1);
            String var10001 = PrefixManager.stockmarket();
            player.sendMessage(Message.raw((String)(var10001 + String.format(Langs.stockmarket().splitSuccess(), stock.getName()))));
        }
    }

    private void handleBuy(Player player, int stockId, int shares) {
        StockData stock = StockDataService.getStock(stockId);
        if (stock != null) {
            long now = System.currentTimeMillis();
            long lastTrade = this.tradeCooldowns.getOrDefault(this.playerRef.getUuid(), 0L);
            int cooldownSec = Configs.stockmarket().getTradeCooldownSeconds();
            boolean bypassCooldown = player.hasPermission("serverrocket.stockmarket.bypass.cooldown");
            if (!bypassCooldown && now - lastTrade < (long)cooldownSec * 1000L) {
                player.sendMessage(Message.raw((String)(PrefixManager.stockmarket() + " Please wait before trading again.")));
            } else if (stock.getAvailableShares() < shares) {
                String var27 = PrefixManager.stockmarket();
                player.sendMessage(Message.raw((String)(var27 + Langs.stockmarket().notEnoughShares())));
            } else {
                BigDecimal multiplier = BigDecimal.valueOf(Math.pow(1.01, shares));
                BigDecimal newPrice = stock.getPrice().multiply(multiplier).setScale(2, RoundingMode.HALF_UP);
                boolean bypassLimits = player.hasPermission("serverrocket.stockmarket.bypass.limits");
                if (!bypassLimits) {
                    BigDecimal maxDiff;
                    BigDecimal maxVol = BigDecimal.valueOf(Configs.stockmarket().getMaxVolatilityPerTrade()).divide(BigDecimal.valueOf(100L));
                    BigDecimal priceDiff = newPrice.subtract(stock.getPrice()).abs();
                    if (priceDiff.compareTo(maxDiff = stock.getPrice().multiply(maxVol)) > 0) {
                        newPrice = stock.getPrice().add(maxDiff).setScale(2, RoundingMode.HALF_UP);
                    }
                }
                BigDecimal totalCost = newPrice.multiply(BigDecimal.valueOf(shares));
                BigDecimal feePercent = BigDecimal.valueOf(Configs.stockmarket().getTradingFeePercent()).divide(BigDecimal.valueOf(100L));
                BigDecimal fee = totalCost.multiply(feePercent).setScale(2, RoundingMode.HALF_UP);
                BigDecimal totalToPay = totalCost.add(fee);
                if (EconomyDataService.removeMoney(this.playerRef.getUuid(), totalToPay, "STOCK_BUY", "Bought " + shares + " shares of " + stock.getSymbol() + " (Fee: " + String.valueOf(fee) + ")")) {
                    PlayerStockData psd = StockDataService.getPlayerStock(this.playerRef.getUuid(), stockId);
                    BigDecimal oldTotalVal = psd.getAverageBuyPrice().multiply(BigDecimal.valueOf(psd.getShares()));
                    BigDecimal newTotalVal = oldTotalVal.add(totalCost);
                    int newShares = psd.getShares() + shares;
                    BigDecimal newAvgPrice = newTotalVal.divide(BigDecimal.valueOf(newShares), 2, RoundingMode.HALF_UP);
                    StockDataService.setPlayerStock(new PlayerStockData(this.playerRef.getUuid(), stockId, newShares, newAvgPrice, psd.getRealizedProfit()));
                    StockDataService.updateStockPrice(stockId, newPrice);
                    StockDataService.updateAvailableShares(stockId, stock.getAvailableShares() - shares);
                    this.tradeCooldowns.put(this.playerRef.getUuid(), now);
                    String var10001 = PrefixManager.economy();
                    player.sendMessage(Message.raw((String)(var10001 + String.format(Langs.stockmarket().buySuccess(), shares, stock.getSymbol()))));
                } else {
                    String var26 = PrefixManager.economy();
                    player.sendMessage(Message.raw((String)(var26 + Langs.stockmarket().notEnoughMoney())));
                }
            }
        }
    }

    private void handleSell(Player player, int stockId, int shares) {
        StockData stock = StockDataService.getStock(stockId);
        if (stock != null) {
            long now = System.currentTimeMillis();
            long lastTrade = this.tradeCooldowns.getOrDefault(this.playerRef.getUuid(), 0L);
            int cooldownSec = Configs.stockmarket().getTradeCooldownSeconds();
            boolean bypassCooldown = player.hasPermission("serverrocket.stockmarket.bypass.cooldown");
            if (!bypassCooldown && now - lastTrade < (long)cooldownSec * 1000L) {
                player.sendMessage(Message.raw((String)(PrefixManager.stockmarket() + " Please wait before trading again.")));
            } else {
                PlayerStockData psd = StockDataService.getPlayerStock(this.playerRef.getUuid(), stockId);
                if (psd.getShares() < shares) {
                    String var25 = PrefixManager.economy();
                    player.sendMessage(Message.raw((String)(var25 + Langs.stockmarket().notEnoughShares())));
                } else {
                    BigDecimal multiplier = BigDecimal.valueOf(Math.pow(0.99, shares));
                    BigDecimal newPrice = stock.getPrice().multiply(multiplier).setScale(2, RoundingMode.HALF_UP);
                    boolean bypassLimits = player.hasPermission("serverrocket.stockmarket.bypass.limits");
                    if (!bypassLimits) {
                        BigDecimal maxDiff;
                        BigDecimal maxVol = BigDecimal.valueOf(Configs.stockmarket().getMaxVolatilityPerTrade()).divide(BigDecimal.valueOf(100L));
                        BigDecimal priceDiff = stock.getPrice().subtract(newPrice).abs();
                        if (priceDiff.compareTo(maxDiff = stock.getPrice().multiply(maxVol)) > 0) {
                            newPrice = stock.getPrice().subtract(maxDiff).setScale(2, RoundingMode.HALF_UP);
                        }
                    }
                    BigDecimal totalGain = newPrice.multiply(BigDecimal.valueOf(shares));
                    BigDecimal feePercent = BigDecimal.valueOf(Configs.stockmarket().getTradingFeePercent()).divide(BigDecimal.valueOf(100L));
                    BigDecimal fee = totalGain.multiply(feePercent).setScale(2, RoundingMode.HALF_UP);
                    BigDecimal netGain = totalGain.subtract(fee);
                    EconomyDataService.addMoney(this.playerRef.getUuid(), netGain, "STOCK_SELL", "Sold " + shares + " shares of " + stock.getSymbol() + " (Fee: " + String.valueOf(fee) + ")");
                    BigDecimal costBasis = psd.getAverageBuyPrice().multiply(BigDecimal.valueOf(shares));
                    BigDecimal profitFromTrade = totalGain.subtract(costBasis).subtract(fee);
                    BigDecimal newRealizedProfit = psd.getRealizedProfit().add(profitFromTrade);
                    StockDataService.setPlayerStock(new PlayerStockData(this.playerRef.getUuid(), stockId, psd.getShares() - shares, psd.getAverageBuyPrice(), newRealizedProfit));
                    StockDataService.updateStockPrice(stockId, newPrice);
                    StockDataService.updateAvailableShares(stockId, stock.getAvailableShares() + shares);
                    this.tradeCooldowns.put(this.playerRef.getUuid(), now);
                    String var10001 = PrefixManager.economy();
                    player.sendMessage(Message.raw((String)(var10001 + String.format(Langs.stockmarket().sellSuccess(), shares, stock.getSymbol()))));
                }
            }
        }
    }
}

