/*
 * Decompiled with CFR 0.152.
 */
package ch.serverrocket.stockmarket.subcommands;

import ch.serverrocket.command.CommandUsage;
import ch.serverrocket.config.Configs;
import ch.serverrocket.database.stockmarket.StockDataService;
import ch.serverrocket.lang.Langs;
import ch.serverrocket.messages.PrefixManager;
import com.hypixel.hytale.component.Ref;
import com.hypixel.hytale.component.Store;
import com.hypixel.hytale.server.core.Message;
import com.hypixel.hytale.server.core.command.system.CommandContext;
import com.hypixel.hytale.server.core.command.system.arguments.system.Argument;
import com.hypixel.hytale.server.core.command.system.arguments.system.OptionalArg;
import com.hypixel.hytale.server.core.command.system.arguments.types.ArgTypes;
import com.hypixel.hytale.server.core.command.system.arguments.types.ArgumentType;
import com.hypixel.hytale.server.core.command.system.basecommands.AbstractPlayerCommand;
import com.hypixel.hytale.server.core.universe.PlayerRef;
import com.hypixel.hytale.server.core.universe.world.World;
import com.hypixel.hytale.server.core.universe.world.storage.EntityStore;
import org.checkerframework.checker.nullness.compatqual.NonNullDecl;

public class StockMarketCreateCommand
extends AbstractPlayerCommand {
    private final OptionalArg<String> nameArg = this.withOptionalArg("name", "stockmarket.commands.name", (ArgumentType)ArgTypes.STRING);
    private final OptionalArg<String> symbolArg = this.withOptionalArg("symbol", "stockmarket.commands.symbol", (ArgumentType)ArgTypes.STRING);
    private final OptionalArg<Double> priceArg = this.withOptionalArg("price", "stockmarket.commands.price", (ArgumentType)ArgTypes.DOUBLE);
    private final OptionalArg<Integer> sharesArg = this.withOptionalArg("shares", "stockmarket.commands.shares", (ArgumentType)ArgTypes.INTEGER);

    public StockMarketCreateCommand() {
        super("create", "stockmarket.commands.create.desc");
    }

    protected void execute(@NonNullDecl CommandContext context, @NonNullDecl Store<EntityStore> store, @NonNullDecl Ref<EntityStore> ref, @NonNullDecl PlayerRef playerRef, @NonNullDecl World world) {
        boolean onlyAdmins = Configs.stockmarket().isOnlyAdminsCanCreate();
        boolean isAdmin = context.sender().hasPermission("serverrocket.stockmarket.admin");
        if (onlyAdmins && !isAdmin) {
            String var18 = PrefixManager.serverrocket();
            context.sendMessage(Message.raw((String)(var18 + " " + Langs.serverrocket().noPermission())));
        } else if (!isAdmin && !context.sender().hasPermission("serverrocket.stockmarket.create")) {
            String var17 = PrefixManager.serverrocket();
            context.sendMessage(Message.raw((String)(var17 + " " + Langs.serverrocket().noPermission())));
        } else if (CommandUsage.requireArgs(context, new Argument[]{this.nameArg, this.symbolArg, this.priceArg, this.sharesArg})) {
            String name = (String)this.nameArg.get(context);
            String symbol = (String)this.symbolArg.get(context);
            Double price = (Double)this.priceArg.get(context);
            Integer shares = (Integer)this.sharesArg.get(context);
            try {
                int count;
                if (!isAdmin && (count = StockDataService.getStocksCountByOwner(playerRef.getUuid())) >= Configs.stockmarket().getMaxStocksPerPlayer()) {
                    String var16 = PrefixManager.stockmarket();
                    context.sendMessage(Message.raw((String)(var16 + String.format(Langs.stockmarket().limitReached(), Configs.stockmarket().getMaxStocksPerPlayer()))));
                    return;
                }
                if (StockDataService.createStock(name, symbol, playerRef.getUuid(), price, (int)shares)) {
                    String var14 = PrefixManager.stockmarket();
                    context.sendMessage(Message.raw((String)(var14 + String.format(Langs.stockmarket().createSuccess(), name, symbol))));
                } else {
                    String var15 = PrefixManager.stockmarket();
                    context.sendMessage(Message.raw((String)(var15 + Langs.stockmarket().invalidArgs())));
                }
            }
            catch (Exception var13) {
                String var10001 = PrefixManager.stockmarket();
                context.sendMessage(Message.raw((String)(var10001 + Langs.stockmarket().invalidArgs())));
            }
        }
    }
}

