/*
 * Decompiled with CFR 0.152.
 */
package ch.serverrocket.stockmarket.subcommands;

import ch.serverrocket.command.CommandUsage;
import ch.serverrocket.database.stockmarket.StockDataService;
import ch.serverrocket.lang.Langs;
import ch.serverrocket.messages.PrefixManager;
import com.hypixel.hytale.component.Ref;
import com.hypixel.hytale.component.Store;
import com.hypixel.hytale.server.core.Message;
import com.hypixel.hytale.server.core.command.system.CommandContext;
import com.hypixel.hytale.server.core.command.system.arguments.system.Argument;
import com.hypixel.hytale.server.core.command.system.arguments.system.OptionalArg;
import com.hypixel.hytale.server.core.command.system.arguments.types.ArgTypes;
import com.hypixel.hytale.server.core.command.system.arguments.types.ArgumentType;
import com.hypixel.hytale.server.core.command.system.basecommands.AbstractPlayerCommand;
import com.hypixel.hytale.server.core.universe.PlayerRef;
import com.hypixel.hytale.server.core.universe.world.World;
import com.hypixel.hytale.server.core.universe.world.storage.EntityStore;
import java.math.BigDecimal;
import org.checkerframework.checker.nullness.compatqual.NonNullDecl;

public class StockMarketDividendCommand
extends AbstractPlayerCommand {
    private final OptionalArg<Double> amountArg = this.withOptionalArg("amount", "stockmarket.commands.dividend.amount", (ArgumentType)ArgTypes.DOUBLE);

    public StockMarketDividendCommand() {
        super("dividend", "stockmarket.commands.dividend.desc");
    }

    protected void execute(@NonNullDecl CommandContext context, @NonNullDecl Store<EntityStore> store, @NonNullDecl Ref<EntityStore> ref, @NonNullDecl PlayerRef playerRef, @NonNullDecl World world) {
        if (!context.sender().hasPermission("serverrocket.stockmarket.dividend.trigger")) {
            String var7 = PrefixManager.serverrocket();
            context.sendMessage(Message.raw((String)(var7 + " " + Langs.serverrocket().noPermission())));
        } else if (CommandUsage.requireArgs(context, new Argument[]{this.amountArg})) {
            Double amount = (Double)this.amountArg.get(context);
            if (amount != null && !(amount <= 0.0)) {
                StockDataService.payoutDividends(BigDecimal.valueOf(amount));
                String var10001 = PrefixManager.stockmarket();
                context.sendMessage(Message.raw((String)(var10001 + " Dividend payout triggered: " + amount + "$ per share.")));
            } else {
                context.sendMessage(Message.raw((String)(PrefixManager.stockmarket() + " Invalid amount.")));
            }
        }
    }
}

