/*
 * Decompiled with CFR 0.152.
 */
package ch.serverrocket.utility;

import ch.serverrocket.lang.Langs;
import ch.serverrocket.messages.PrefixManager;
import com.hypixel.hytale.component.Ref;
import com.hypixel.hytale.component.Store;
import com.hypixel.hytale.server.core.Message;
import com.hypixel.hytale.server.core.command.system.CommandContext;
import com.hypixel.hytale.server.core.command.system.basecommands.AbstractPlayerCommand;
import com.hypixel.hytale.server.core.universe.PlayerRef;
import com.hypixel.hytale.server.core.universe.world.World;
import com.hypixel.hytale.server.core.universe.world.storage.EntityStore;
import java.util.Collections;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import org.checkerframework.checker.nullness.compatqual.NonNullDecl;

public class AfkCommand
extends AbstractPlayerCommand {
    private static final Set<UUID> AFK_PLAYERS = Collections.newSetFromMap(new ConcurrentHashMap());

    public AfkCommand() {
        super("afk", "utility.afk.desc");
    }

    protected void execute(@NonNullDecl CommandContext context, @NonNullDecl Store<EntityStore> store, @NonNullDecl Ref<EntityStore> ref, @NonNullDecl PlayerRef playerRef, @NonNullDecl World world) {
        if (!context.sender().hasPermission("serverrocket.utility.afk")) {
            String var10001 = PrefixManager.serverrocket();
            context.sendMessage(Message.raw((String)(var10001 + " " + Langs.serverrocket().noPermission())));
        } else {
            UUID uuid = playerRef.getUuid();
            if (AFK_PLAYERS.contains(uuid)) {
                AFK_PLAYERS.remove(uuid);
                String msg = String.format(Langs.utility().afkDisabled(), playerRef.getUsername());
                world.getPlayerRefs().forEach(p -> {
                    String var10001 = PrefixManager.minerva();
                    p.sendMessage(Message.raw((String)(var10001 + msg)));
                });
            } else {
                AFK_PLAYERS.add(uuid);
                String msg = String.format(Langs.utility().afkEnabled(), playerRef.getUsername());
                world.getPlayerRefs().forEach(p -> {
                    String var10001 = PrefixManager.minerva();
                    p.sendMessage(Message.raw((String)(var10001 + msg)));
                });
            }
        }
    }
}

