/*
 * Decompiled with CFR 0.152.
 */
package ch.serverrocket.utility;

import ch.serverrocket.lang.Langs;
import ch.serverrocket.messages.PrefixManager;
import com.hypixel.hytale.component.Ref;
import com.hypixel.hytale.component.Store;
import com.hypixel.hytale.protocol.MovementSettings;
import com.hypixel.hytale.server.core.Message;
import com.hypixel.hytale.server.core.command.system.CommandContext;
import com.hypixel.hytale.server.core.command.system.basecommands.AbstractPlayerCommand;
import com.hypixel.hytale.server.core.entity.entities.Player;
import com.hypixel.hytale.server.core.entity.entities.player.movement.MovementManager;
import com.hypixel.hytale.server.core.io.PacketHandler;
import com.hypixel.hytale.server.core.universe.PlayerRef;
import com.hypixel.hytale.server.core.universe.world.World;
import com.hypixel.hytale.server.core.universe.world.storage.EntityStore;
import org.checkerframework.checker.nullness.compatqual.NonNullDecl;

public class FlyCommand
extends AbstractPlayerCommand {
    public FlyCommand() {
        super("fly", "utility.fly.desc");
    }

    protected void execute(@NonNullDecl CommandContext context, @NonNullDecl Store<EntityStore> store, @NonNullDecl Ref<EntityStore> ref, @NonNullDecl PlayerRef playerRef, @NonNullDecl World world) {
        if (!context.sender().hasPermission("serverrocket.utility.fly")) {
            String var15 = PrefixManager.serverrocket();
            context.sendMessage(Message.raw((String)(var15 + " " + Langs.serverrocket().noPermission())));
        } else {
            MovementManager mm4 = (MovementManager)store.getComponent(ref, MovementManager.getComponentType());
            if (mm4 != null) {
                PacketHandler connection;
                Player target;
                boolean next;
                MovementSettings settings = mm4.getSettings();
                MovementSettings defaults = mm4.getDefaultSettings();
                boolean current = false;
                if (settings != null) {
                    current = settings.canFly;
                } else {
                    if (defaults == null) {
                        return;
                    }
                    current = defaults.canFly;
                }
                boolean bl = next = !current;
                if (settings != null) {
                    settings.canFly = next;
                }
                if (defaults != null) {
                    defaults.canFly = next;
                    if (settings == null) {
                        mm4.applyDefaultSettings();
                    }
                }
                if ((target = (Player)store.getComponent(ref, Player.getComponentType())) != null && (connection = target.getPlayerConnection()) != null) {
                    mm4.update(connection);
                }
                String msg = next ? String.format(Langs.utility().flyEnabled(), playerRef.getUsername()) : String.format(Langs.utility().flyDisabled(), playerRef.getUsername());
                String var10001 = PrefixManager.minerva();
                context.sendMessage(Message.raw((String)(var10001 + msg)));
            }
        }
    }
}

