/*
 * Decompiled with CFR 0.152.
 */
package ch.serverrocket.utility;

import ch.serverrocket.lang.Langs;
import ch.serverrocket.messages.PrefixManager;
import com.hypixel.hytale.component.Ref;
import com.hypixel.hytale.component.Store;
import com.hypixel.hytale.server.core.Message;
import com.hypixel.hytale.server.core.command.system.CommandContext;
import com.hypixel.hytale.server.core.command.system.arguments.system.OptionalArg;
import com.hypixel.hytale.server.core.command.system.arguments.types.ArgTypes;
import com.hypixel.hytale.server.core.command.system.arguments.types.ArgumentType;
import com.hypixel.hytale.server.core.command.system.basecommands.AbstractPlayerCommand;
import com.hypixel.hytale.server.core.modules.entitystats.EntityStatMap;
import com.hypixel.hytale.server.core.modules.entitystats.asset.DefaultEntityStatTypes;
import com.hypixel.hytale.server.core.universe.PlayerRef;
import com.hypixel.hytale.server.core.universe.world.World;
import com.hypixel.hytale.server.core.universe.world.storage.EntityStore;
import org.checkerframework.checker.nullness.compatqual.NonNullDecl;

public class KillCommand
extends AbstractPlayerCommand {
    private final OptionalArg<PlayerRef> targetArg = this.withOptionalArg("player", "utility.kill.target", (ArgumentType)ArgTypes.PLAYER_REF);

    public KillCommand() {
        super("kill", "utility.kill.desc");
    }

    protected void execute(@NonNullDecl CommandContext context, @NonNullDecl Store<EntityStore> store, @NonNullDecl Ref<EntityStore> ref, @NonNullDecl PlayerRef playerRef, @NonNullDecl World world) {
        if (!context.sender().hasPermission("serverrocket.utility.kill")) {
            String var12 = PrefixManager.serverrocket();
            context.sendMessage(Message.raw((String)(var12 + " " + Langs.serverrocket().noPermission())));
        } else {
            boolean other;
            PlayerRef targetRef = (PlayerRef)this.targetArg.get(context);
            boolean bl = other = targetRef != null && !targetRef.getUuid().equals(playerRef.getUuid());
            if (other && !context.sender().hasPermission("serverrocket.utility.kill.others")) {
                String var11 = PrefixManager.serverrocket();
                context.sendMessage(Message.raw((String)(var11 + " " + Langs.serverrocket().noPermission())));
            } else {
                Ref targetEntityRef;
                Store targetStore;
                EntityStatMap statMap;
                if (targetRef == null) {
                    targetRef = playerRef;
                }
                if ((statMap = (EntityStatMap)(targetStore = (targetEntityRef = targetRef.getReference()).getStore()).getComponent(targetEntityRef, EntityStatMap.getComponentType())) != null) {
                    statMap.setStatValue(DefaultEntityStatTypes.getHealth(), 0.0f);
                }
                String var10001 = PrefixManager.minerva();
                context.sendMessage(Message.raw((String)(var10001 + String.format(Langs.utility().killSuccess(), targetRef.getUsername()))));
            }
        }
    }
}

