/*
 * Decompiled with CFR 0.152.
 */
package ch.serverrocket.utility;

import ch.serverrocket.command.CommandUsage;
import ch.serverrocket.lang.Langs;
import ch.serverrocket.messages.PrefixManager;
import com.hypixel.hytale.component.Ref;
import com.hypixel.hytale.component.Store;
import com.hypixel.hytale.server.core.Message;
import com.hypixel.hytale.server.core.command.system.AbstractCommand;
import com.hypixel.hytale.server.core.command.system.CommandContext;
import com.hypixel.hytale.server.core.command.system.arguments.system.RequiredArg;
import com.hypixel.hytale.server.core.command.system.arguments.types.ArgTypes;
import com.hypixel.hytale.server.core.command.system.arguments.types.ArgumentType;
import com.hypixel.hytale.server.core.command.system.basecommands.AbstractPlayerCommand;
import com.hypixel.hytale.server.core.universe.PlayerRef;
import com.hypixel.hytale.server.core.universe.world.World;
import com.hypixel.hytale.server.core.universe.world.storage.EntityStore;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import org.checkerframework.checker.nullness.compatqual.NonNullDecl;

public class MsgCommand
extends AbstractPlayerCommand {
    private final RequiredArg<PlayerRef> targetArg = this.withRequiredArg("player", "utility.msg.target", (ArgumentType)ArgTypes.PLAYER_REF);
    private final RequiredArg<String> msgArg = this.withRequiredArg("message", "utility.msg.text", (ArgumentType)ArgTypes.STRING);
    public static final Map<UUID, UUID> SOCIAL_SPY = new ConcurrentHashMap<UUID, UUID>();

    public MsgCommand() {
        super("msg", "utility.msg.desc");
        CommandUsage.addUsageVariant((AbstractCommand)this);
    }

    protected void execute(@NonNullDecl CommandContext context, @NonNullDecl Store<EntityStore> store, @NonNullDecl Ref<EntityStore> ref, @NonNullDecl PlayerRef playerRef, @NonNullDecl World world) {
        if (!context.sender().hasPermission("serverrocket.utility.msg")) {
            String var10001 = PrefixManager.serverrocket();
            context.sendMessage(Message.raw((String)(var10001 + " " + Langs.serverrocket().noPermission())));
        } else {
            PlayerRef target = (PlayerRef)this.targetArg.get(context);
            String text = (String)this.msgArg.get(context);
            String formatted = String.format(Langs.utility().msgFormat(), playerRef.getUsername(), target.getUsername(), text);
            Message msg = Message.raw((String)formatted);
            playerRef.sendMessage(msg);
            target.sendMessage(msg);
            for (PlayerRef p : this.getOnlinePlayers(world)) {
                if (!SOCIAL_SPY.containsKey(p.getUuid()) || p.getUuid().equals(playerRef.getUuid()) || p.getUuid().equals(target.getUuid())) continue;
                p.sendMessage(Message.raw((String)("[Spy] " + formatted)));
            }
        }
    }

    private Collection<PlayerRef> getOnlinePlayers(World world) {
        try {
            Object worldsObj;
            Object universe = this.tryGetUniverseFromWorld(world);
            if (universe != null && (worldsObj = this.tryGetWorldsMap(universe)) instanceof Map) {
                Map worlds = (Map)worldsObj;
                HashMap<UUID, PlayerRef> players = new HashMap<UUID, PlayerRef>();
                for (Object w : worlds.values()) {
                    if (!(w instanceof World)) continue;
                    World worldRef = (World)w;
                    for (PlayerRef ref : worldRef.getPlayerRefs()) {
                        players.put(ref.getUuid(), ref);
                    }
                }
                return new ArrayList<PlayerRef>(players.values());
            }
        }
        catch (ReflectiveOperationException | RuntimeException exception) {
            // empty catch block
        }
        return world.getPlayerRefs();
    }

    private Object tryGetUniverseFromWorld(World world) throws ReflectiveOperationException {
        try {
            return world.getClass().getMethod("getUniverse", new Class[0]).invoke((Object)world, new Object[0]);
        }
        catch (ReflectiveOperationException var4) {
            Class<?> serverClass = Class.forName("com.hypixel.hytale.server.core.HytaleServer");
            Object server = serverClass.getMethod("get", new Class[0]).invoke(null, new Object[0]);
            return serverClass.getMethod("getUniverse", new Class[0]).invoke(server, new Object[0]);
        }
    }

    private Object tryGetWorldsMap(Object universe) throws ReflectiveOperationException {
        try {
            return universe.getClass().getMethod("getWorlds", new Class[0]).invoke(universe, new Object[0]);
        }
        catch (ReflectiveOperationException var4) {
            try {
                Field field = universe.getClass().getDeclaredField("unmodifiableWorlds");
                field.setAccessible(true);
                return field.get(universe);
            }
            catch (ReflectiveOperationException var3) {
                Field field = universe.getClass().getDeclaredField("worlds");
                field.setAccessible(true);
                return field.get(universe);
            }
        }
    }
}

