/*
 * Decompiled with CFR 0.152.
 */
package ch.serverrocket.utility;

import ch.serverrocket.lang.Langs;
import ch.serverrocket.messages.PrefixManager;
import ch.serverrocket.utility.TeleportService;
import com.hypixel.hytale.component.Ref;
import com.hypixel.hytale.component.Store;
import com.hypixel.hytale.math.vector.Vector3f;
import com.hypixel.hytale.server.core.Message;
import com.hypixel.hytale.server.core.command.system.CommandContext;
import com.hypixel.hytale.server.core.command.system.basecommands.AbstractPlayerCommand;
import com.hypixel.hytale.server.core.universe.PlayerRef;
import com.hypixel.hytale.server.core.universe.world.World;
import com.hypixel.hytale.server.core.universe.world.storage.EntityStore;
import java.util.Collection;
import org.checkerframework.checker.nullness.compatqual.NonNullDecl;

public class NearCommand
extends AbstractPlayerCommand {
    public NearCommand() {
        super("near", "utility.near.desc");
    }

    protected void execute(@NonNullDecl CommandContext context, @NonNullDecl Store<EntityStore> store, @NonNullDecl Ref<EntityStore> ref, @NonNullDecl PlayerRef playerRef, @NonNullDecl World world) {
        if (!context.sender().hasPermission("serverrocket.utility.near")) {
            String var14 = PrefixManager.serverrocket();
            context.sendMessage(Message.raw((String)(var14 + " " + Langs.serverrocket().noPermission())));
        } else {
            Vector3f myPos = TeleportService.getPosition(store, ref);
            if (myPos != null) {
                Collection players = world.getPlayerRefs();
                StringBuilder sb = new StringBuilder("Nearby players: ");
                boolean found = false;
                for (PlayerRef p : players) {
                    float dist;
                    Vector3f pPos;
                    if (p.getUuid().equals(playerRef.getUuid()) || (pPos = TeleportService.getPosition((Store<EntityStore>)p.getReference().getStore(), (Ref<EntityStore>)p.getReference())) == null || !((dist = (float)Math.sqrt(Math.pow(myPos.x - pPos.x, 2.0) + Math.pow(myPos.y - pPos.y, 2.0) + Math.pow(myPos.z - pPos.z, 2.0))) < 200.0f)) continue;
                    if (found) {
                        sb.append(", ");
                    }
                    sb.append(p.getUsername());
                    found = true;
                }
                if (!found) {
                    sb.append("none");
                }
                String var10001 = PrefixManager.serverrocket();
                context.sendMessage(Message.raw((String)(var10001 + sb.toString())));
            }
        }
    }
}

