/*
 * Decompiled with CFR 0.152.
 */
package ch.serverrocket.utility;

import ch.serverrocket.lang.Langs;
import ch.serverrocket.messages.PrefixManager;
import com.hypixel.hytale.component.Ref;
import com.hypixel.hytale.component.Store;
import com.hypixel.hytale.server.core.Message;
import com.hypixel.hytale.server.core.command.system.CommandContext;
import com.hypixel.hytale.server.core.command.system.arguments.system.OptionalArg;
import com.hypixel.hytale.server.core.command.system.arguments.types.ArgTypes;
import com.hypixel.hytale.server.core.command.system.arguments.types.ArgumentType;
import com.hypixel.hytale.server.core.command.system.basecommands.AbstractPlayerCommand;
import com.hypixel.hytale.server.core.entity.entities.Player;
import com.hypixel.hytale.server.core.universe.PlayerRef;
import com.hypixel.hytale.server.core.universe.world.World;
import com.hypixel.hytale.server.core.universe.world.storage.EntityStore;
import org.checkerframework.checker.nullness.compatqual.NonNullDecl;

public class RepairCommand
extends AbstractPlayerCommand {
    private final OptionalArg<PlayerRef> targetArg = this.withOptionalArg("player", "utility.repair.target", (ArgumentType)ArgTypes.PLAYER_REF);

    public RepairCommand() {
        super("repair", "utility.repair.desc");
    }

    protected void execute(@NonNullDecl CommandContext context, @NonNullDecl Store<EntityStore> store, @NonNullDecl Ref<EntityStore> ref, @NonNullDecl PlayerRef playerRef, @NonNullDecl World world) {
        if (!context.sender().hasPermission("serverrocket.utility.repair")) {
            String var18 = PrefixManager.serverrocket();
            context.sendMessage(Message.raw((String)(var18 + " " + Langs.serverrocket().noPermission())));
        } else {
            boolean other;
            PlayerRef targetRef = (PlayerRef)this.targetArg.get(context);
            boolean bl = other = targetRef != null && !targetRef.getUuid().equals(playerRef.getUuid());
            if (other && !context.sender().hasPermission("serverrocket.utility.repair.other")) {
                String var17 = PrefixManager.serverrocket();
                context.sendMessage(Message.raw((String)(var17 + " " + Langs.serverrocket().noPermission())));
            } else {
                Player targetPlayer;
                if (targetRef == null) {
                    targetRef = playerRef;
                }
                if ((targetPlayer = (Player)targetRef.getReference().getStore().getComponent(targetRef.getReference(), Player.getComponentType())) != null) {
                    try {
                        Object repaired;
                        Object inventory = targetPlayer.getClass().getMethod("getInventory", new Class[0]).invoke((Object)targetPlayer, new Object[0]);
                        Object hotbar = inventory.getClass().getMethod("getHotbar", new Class[0]).invoke(inventory, new Object[0]);
                        Object activeSlotObj = inventory.getClass().getMethod("getActiveHotbarSlot", new Class[0]).invoke(inventory, new Object[0]);
                        short slotIndex = ((Number)activeSlotObj).shortValue();
                        Object itemStack = hotbar.getClass().getMethod("getItemStack", Short.TYPE).invoke(hotbar, slotIndex);
                        if (itemStack != null && (repaired = this.tryRestoreDurability(itemStack)) != null) {
                            hotbar.getClass().getMethod("setItemStackForSlot", Short.TYPE, itemStack.getClass(), Boolean.TYPE).invoke(hotbar, slotIndex, repaired, true);
                        }
                    }
                    catch (Exception inventory) {
                        // empty catch block
                    }
                }
                if (other) {
                    String var10001 = PrefixManager.minerva();
                    context.sendMessage(Message.raw((String)(var10001 + "Item repaired for " + targetRef.getUsername())));
                } else {
                    String var16 = PrefixManager.minerva();
                    context.sendMessage(Message.raw((String)(var16 + Langs.utility().repairSuccess())));
                }
            }
        }
    }

    private Object tryRestoreDurability(Object itemStack) {
        try {
            return itemStack.getClass().getMethod("withRestoredDurability", new Class[0]).invoke(itemStack, new Object[0]);
        }
        catch (Exception var4) {
            try {
                return itemStack.getClass().getMethod("withDurability", Double.TYPE).invoke(itemStack, 0.0);
            }
            catch (Exception var3) {
                return null;
            }
        }
    }
}

