/*
 * Decompiled with CFR 0.152.
 */
package ch.serverrocket.utility;

import ch.serverrocket.command.CommandUsage;
import ch.serverrocket.lang.Langs;
import ch.serverrocket.messages.PrefixManager;
import ch.serverrocket.utility.TeleportService;
import com.hypixel.hytale.component.Ref;
import com.hypixel.hytale.component.Store;
import com.hypixel.hytale.math.vector.Vector3f;
import com.hypixel.hytale.server.core.Message;
import com.hypixel.hytale.server.core.command.system.AbstractCommand;
import com.hypixel.hytale.server.core.command.system.CommandContext;
import com.hypixel.hytale.server.core.command.system.arguments.system.RequiredArg;
import com.hypixel.hytale.server.core.command.system.arguments.types.ArgTypes;
import com.hypixel.hytale.server.core.command.system.arguments.types.ArgumentType;
import com.hypixel.hytale.server.core.command.system.basecommands.AbstractPlayerCommand;
import com.hypixel.hytale.server.core.universe.PlayerRef;
import com.hypixel.hytale.server.core.universe.world.World;
import com.hypixel.hytale.server.core.universe.world.storage.EntityStore;
import org.checkerframework.checker.nullness.compatqual.NonNullDecl;

public class TeleportCommand
extends AbstractPlayerCommand {
    private final RequiredArg<PlayerRef> targetArg = this.withRequiredArg("player", "utility.teleport.target", (ArgumentType)ArgTypes.PLAYER_REF);

    public TeleportCommand() {
        super("teleport", "utility.teleport.desc");
        CommandUsage.addUsageVariant((AbstractCommand)this);
    }

    protected void execute(@NonNullDecl CommandContext context, @NonNullDecl Store<EntityStore> store, @NonNullDecl Ref<EntityStore> ref, @NonNullDecl PlayerRef playerRef, @NonNullDecl World world) {
        if (!context.sender().hasPermission("serverrocket.utility.teleport")) {
            String var8 = PrefixManager.serverrocket();
            context.sendMessage(Message.raw((String)(var8 + " " + Langs.serverrocket().noPermission())));
        } else {
            PlayerRef target = (PlayerRef)this.targetArg.get(context);
            Vector3f targetPos = TeleportService.getPosition((Store<EntityStore>)target.getReference().getStore(), (Ref<EntityStore>)target.getReference());
            if (targetPos != null) {
                TeleportService.teleport(world, ref, store, targetPos);
                String var10001 = PrefixManager.minerva();
                context.sendMessage(Message.raw((String)(var10001 + String.format(Langs.utility().tpSuccess(), target.getUsername()))));
            }
        }
    }
}

