/*
 * Decompiled with CFR 0.152.
 */
package ch.serverrocket.utility;

import com.hypixel.hytale.component.Component;
import com.hypixel.hytale.component.Ref;
import com.hypixel.hytale.component.Store;
import com.hypixel.hytale.math.vector.Vector3d;
import com.hypixel.hytale.math.vector.Vector3f;
import com.hypixel.hytale.server.core.modules.entity.component.TransformComponent;
import com.hypixel.hytale.server.core.modules.entity.teleport.Teleport;
import com.hypixel.hytale.server.core.universe.world.World;
import com.hypixel.hytale.server.core.universe.world.storage.EntityStore;

public final class TeleportService {
    private TeleportService() {
    }

    public static void teleport(World world, Ref<EntityStore> ref, Store<EntityStore> store, Vector3f targetPos) {
        world.execute(() -> {
            TransformComponent transform = (TransformComponent)store.getComponent(ref, TransformComponent.getComponentType());
            if (transform != null) {
                Vector3d posD = new Vector3d((double)targetPos.x, (double)targetPos.y, (double)targetPos.z);
                Teleport tp = new Teleport(posD, new Vector3f(0.0f, 0.0f, 0.0f));
                store.addComponent(ref, Teleport.getComponentType(), (Component)tp);
            }
        });
    }

    public static Vector3f getPosition(Store<EntityStore> store, Ref<EntityStore> ref) {
        TransformComponent transform = (TransformComponent)store.getComponent(ref, TransformComponent.getComponentType());
        if (transform != null) {
            Vector3d p = transform.getPosition();
            return new Vector3f((float)p.x, (float)p.y, (float)p.z);
        }
        return null;
    }
}

