/*
 * Decompiled with CFR 0.152.
 */
package ch.serverrocket.utility;

import ch.serverrocket.command.CommandUsage;
import ch.serverrocket.lang.Langs;
import ch.serverrocket.messages.PrefixManager;
import ch.serverrocket.utility.TeleportService;
import com.hypixel.hytale.component.Ref;
import com.hypixel.hytale.component.Store;
import com.hypixel.hytale.math.vector.Vector3f;
import com.hypixel.hytale.server.core.Message;
import com.hypixel.hytale.server.core.command.system.AbstractCommand;
import com.hypixel.hytale.server.core.command.system.CommandContext;
import com.hypixel.hytale.server.core.command.system.arguments.system.RequiredArg;
import com.hypixel.hytale.server.core.command.system.arguments.types.ArgTypes;
import com.hypixel.hytale.server.core.command.system.arguments.types.ArgumentType;
import com.hypixel.hytale.server.core.command.system.basecommands.AbstractPlayerCommand;
import com.hypixel.hytale.server.core.universe.PlayerRef;
import com.hypixel.hytale.server.core.universe.world.World;
import com.hypixel.hytale.server.core.universe.world.storage.EntityStore;
import org.checkerframework.checker.nullness.compatqual.NonNullDecl;

public class TopCommand
extends AbstractPlayerCommand {
    private final RequiredArg<PlayerRef> targetArg = this.withRequiredArg("player", "utility.top.target", (ArgumentType)ArgTypes.PLAYER_REF);

    public TopCommand() {
        super("top", "utility.top.desc");
        CommandUsage.addUsageVariant((AbstractCommand)this);
    }

    protected void execute(@NonNullDecl CommandContext context, @NonNullDecl Store<EntityStore> store, @NonNullDecl Ref<EntityStore> ref, @NonNullDecl PlayerRef playerRef, @NonNullDecl World world) {
        if (!context.sender().hasPermission("serverrocket.utility.top")) {
            String var12 = PrefixManager.serverrocket();
            context.sendMessage(Message.raw((String)(var12 + " " + Langs.serverrocket().noPermission())));
        } else {
            PlayerRef target = (PlayerRef)this.targetArg.get(context);
            if (target.getUuid().equals(playerRef.getUuid())) {
                context.sendMessage(Message.raw((String)(PrefixManager.serverrocket() + "You must target another player.")));
            } else {
                Ref targetRef;
                Store targetStore = target.getReference().getStore();
                Vector3f pos = TeleportService.getPosition((Store<EntityStore>)targetStore, (Ref<EntityStore>)(targetRef = target.getReference()));
                if (pos != null) {
                    Vector3f topPos = new Vector3f(pos.x, 255.0f, pos.z);
                    World targetWorld = this.getTargetWorld(target, world);
                    TeleportService.teleport(targetWorld, (Ref<EntityStore>)targetRef, (Store<EntityStore>)targetStore, topPos);
                    String var10001 = PrefixManager.serverrocket();
                    context.sendMessage(Message.raw((String)(var10001 + "Teleported " + target.getUsername() + " to #55ffffhighest block#ffffff.")));
                }
            }
        }
    }

    private World getTargetWorld(PlayerRef target, World fallback) {
        try {
            Object result = target.getClass().getMethod("getWorld", new Class[0]).invoke((Object)target, new Object[0]);
            if (result instanceof World) {
                World world = (World)result;
                return world;
            }
        }
        catch (ReflectiveOperationException reflectiveOperationException) {
            // empty catch block
        }
        return fallback;
    }
}

