/*
 * Decompiled with CFR 0.152.
 */
package ch.serverrocket.utility;

import ch.serverrocket.lang.Langs;
import ch.serverrocket.messages.PrefixManager;
import ch.serverrocket.utility.TeleportService;
import ch.serverrocket.utility.TpaRequestStore;
import com.hypixel.hytale.component.Ref;
import com.hypixel.hytale.component.Store;
import com.hypixel.hytale.server.core.Message;
import com.hypixel.hytale.server.core.command.system.CommandContext;
import com.hypixel.hytale.server.core.command.system.basecommands.AbstractPlayerCommand;
import com.hypixel.hytale.server.core.universe.PlayerRef;
import com.hypixel.hytale.server.core.universe.world.World;
import com.hypixel.hytale.server.core.universe.world.storage.EntityStore;
import java.util.UUID;
import org.checkerframework.checker.nullness.compatqual.NonNullDecl;

public class TpAcceptCommand
extends AbstractPlayerCommand {
    public TpAcceptCommand() {
        super("tpaccept", "utility.tpaccept.desc");
    }

    protected void execute(@NonNullDecl CommandContext context, @NonNullDecl Store<EntityStore> store, @NonNullDecl Ref<EntityStore> ref, @NonNullDecl PlayerRef playerRef, @NonNullDecl World world) {
        if (!context.sender().hasPermission("serverrocket.utility.tpaccept")) {
            String var16 = PrefixManager.serverrocket();
            context.sendMessage(Message.raw((String)(var16 + " " + Langs.serverrocket().noPermission())));
        } else {
            UUID requesterUuid = TpaRequestStore.getRequester(playerRef.getUuid());
            if (requesterUuid == null) {
                String var15 = PrefixManager.serverrocket();
                context.sendMessage(Message.raw((String)(var15 + Langs.utility().tpaNoRequest())));
            } else {
                boolean here = TpaRequestStore.isHere(playerRef.getUuid());
                TpaRequestStore.remove(playerRef.getUuid());
                PlayerRef requester = null;
                for (PlayerRef r : world.getPlayerRefs()) {
                    if (!r.getUuid().equals(requesterUuid)) continue;
                    requester = r;
                    break;
                }
                if (requester == null) {
                    String var14 = PrefixManager.serverrocket();
                    context.sendMessage(Message.raw((String)(var14 + Langs.minerva().playerNotFound())));
                } else {
                    if (here) {
                        targetPos = TeleportService.getPosition(store, ref);
                        if (targetPos != null) {
                            TeleportService.teleport(world, (Ref<EntityStore>)requester.getReference(), (Store<EntityStore>)requester.getReference().getStore(), targetPos);
                        }
                    } else {
                        targetPos = TeleportService.getPosition((Store<EntityStore>)requester.getReference().getStore(), (Ref<EntityStore>)requester.getReference());
                        if (targetPos != null) {
                            TeleportService.teleport(world, ref, store, targetPos);
                        }
                    }
                    String var10001 = PrefixManager.serverrocket();
                    context.sendMessage(Message.raw((String)(var10001 + Langs.utility().tpaAccepted())));
                    var10001 = PrefixManager.serverrocket();
                    requester.sendMessage(Message.raw((String)(var10001 + Langs.utility().tpaAccepted())));
                }
            }
        }
    }
}

