/*
 * Decompiled with CFR 0.152.
 */
package ch.serverrocket.utility;

import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;

public final class TpaRequestStore {
    private static final Map<UUID, Req> REQUESTS = new ConcurrentHashMap<UUID, Req>();
    private static final long TIMEOUT_MS = 60000L;

    private TpaRequestStore() {
    }

    public static void putRequest(UUID from, UUID to, boolean here) {
        REQUESTS.put(to, new Req(from, here, System.currentTimeMillis() + 60000L));
    }

    public static UUID getRequester(UUID to) {
        Req r = REQUESTS.get(to);
        if (r != null && System.currentTimeMillis() <= r.expiresAt) {
            return r.from;
        }
        REQUESTS.remove(to);
        return null;
    }

    public static boolean isHere(UUID to) {
        Req r = REQUESTS.get(to);
        return r != null && r.here;
    }

    public static void remove(UUID to) {
        REQUESTS.remove(to);
    }

    private static final class Req {
        final UUID from;
        final boolean here;
        final long expiresAt;

        Req(UUID f, boolean h2, long e) {
            this.from = f;
            this.here = h2;
            this.expiresAt = e;
        }
    }
}

